<?php
extract($settings);
$html_id = pxl_get_element_id($settings);
$tax = ['portfolio-category'];
$select_post_by = $widget->get_setting('select_post_by', 'term_selected');
$source = $post_ids = $post_ids_unselected = [];

if($select_post_by === 'post_selected'){
    $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
}else{
    $source  = $widget->get_setting('source_'.$settings['post_type'], '');
    $post_ids_unselected  = $widget->get_setting('source_'.$settings['post_type'].'_post_ids_unselected', '');
}
 
$orderby   = $widget->get_setting('orderby', 'date');
$order     = $widget->get_setting('order', 'desc');
$limit     = $widget->get_setting('limit', 4);

$query_result = pxl_get_posts_of_grid('portfolio', ['source' => $source, 'orderby' => $orderby, 'order' => $order, 'limit' => $limit, 'post_ids' => $post_ids, 'post_not_in' => $post_ids_unselected ], $tax);

extract($query_result);
 
$post_type            = $widget->get_setting('post_type','portfolio');
$layout               = $widget->get_setting('layout', 'portfolio-spilt-1');
 

$widget->add_render_attribute( 'wrapper', [
    'id'               => $html_id,
    'class'            => 'pxl-portfolio-spilt layout-'.$layout,
]);

$grid_class = 'pxl-portfolio-spilt-inner';
$widget->add_render_attribute( 'grid', 'class', $grid_class);
 
if( count($posts) <= 0){
    echo '<div class="pxl-no-post-grid">'.esc_html__( 'No Post Found', 'adsett' ). '</div>';
    return;
}

$img_size = !empty( $img_size ) ? $img_size : '944x962';
$button_text = !empty( $button_text ) ? $button_text : esc_html__( 'View Details', 'adsett' );
?>

<div <?php pxl_print_html($widget->get_render_attribute_string( 'wrapper' )) ?>>
       
    <div <?php pxl_print_html($widget->get_render_attribute_string('grid')); ?>> 
    	<?php foreach ($posts as $key => $post): ?>
    		<?php 
    			$thumbnail = $thumbnail_url = '';
    			$item_col_cls = 'col-12 col-md-6';
                if (has_post_thumbnail($post->ID)){
                    $img = pxl_get_image_by_size( array(
                        'post_id'  => $post->ID ,
                        'thumb_size' => $img_size,
                        'class' => 'no-lazyload',
                    ));
                    $thumbnail = $img['thumbnail'];
                    $thumbnail_url = $img['url'];
                }else{
                	$item_col_cls = 'col-12';
                } 

                $extra_desc = get_post_meta( $post->ID, 'extra_desc', true );
    		?>
	    	<div class="portfolio-item">
			  	<div class="item-wrap">
				    <div class="item-inner">
				    	<div class="content-wrap row gx-0">
							<div class="col-content <?php echo esc_attr($item_col_cls) ?> align-self-center">
								<h3 class="item-title"><?php pxl_print_html(get_the_title($post->ID)); ?></a></h3>
								<?php if($show_excerpt == 'true' && !empty($extra_desc)): ?>
			                        <div class="item-excerpt">
			                            <?php
			                            if(!empty($extra_desc)){
			                                echo wp_trim_words( $extra_desc, $num_words, null );
			                            } else{
			                                $content = strip_shortcodes( $post->post_content );
			                                $content = apply_filters( 'the_content', $content );
			                                $content = str_replace(']]>', ']]&gt;', $content);
			                                echo wp_trim_words( $content, $num_words, null );
			                            }
			                            ?>
			                        </div>
			                    <?php endif; ?>
			                    <?php if($show_button == 'true'): ?>
									<div class="item-readmore">
			                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="pxl-btn outline-under draw in-dark">
			                                <span class="draw-top-right"></span>
			                                <span class="draw-bottom-left"></span>
			                                <span class="pxl-button-text"><?php pxl_print_html($button_text);?></span>
			                            </a>
			                        </div>
		                        <?php endif; ?>
							</div>
							<?php if(!empty($thumbnail)) :?>
							<div class="col-img <?php echo esc_attr($item_col_cls) ?>">
                                <div class="item-image" style="background: url(<?php echo esc_url($thumbnail_url)?>) center no-repeat; background-size: cover;">
                                    <?php echo wp_kses_post($thumbnail); ?>
                                </div>
							</div>
							<?php endif; ?>
						</div>
				    </div>
			  	</div>
			</div>
		<?php endforeach; ?>
         
    </div>
     
</div>