<?php 
extract($settings);
if(!is_singular( 'portfolio' )) return;
$post_id = get_the_ID();
$client = get_post_meta( $post_id, 'client', true );
$location = get_post_meta( $post_id, 'location', true );
$date_start = get_post_meta( $post_id, 'date_start', true );
$term_list = get_the_term_list( $post_id, 'portfolio-category', '', ' ', '' );
?>
<div class="pxl-portfolio-info">
	<div class="content-inner">
		<?php if(isset($list) && !empty($list) && count($list)): 
        	foreach ($list as $key => $pxl_list): ?>
	            <div class="content-item">
	                <?php if ( !empty( $pxl_list['item_label'] ) ) : ?> 
	                	<span class="lbl d-block"><?php pxl_print_html($pxl_list['item_label'])?>:</span>
	                <?php endif; ?>
	                <?php if ( !empty( $pxl_list['item_content'] ) ) : ?> 
	                	<span class="item-text"><?php pxl_print_html($pxl_list['item_content'])?></span>
	                <?php endif; ?>
	           </div>
	        <?php endforeach; ?>
		<?php endif; ?>
		<?php if( is_singular( 'portfolio' ) && $post_id > 0 ): ?>

			<?php if ( $show_client == 'true' && !empty( $client ) ) : ?> 
				<div class="content-item client">
					<span class="lbl d-block"><?php echo esc_html__( 'Clients', 'adsett' ) ?>:</span>
					<span class="item-text"><?php pxl_print_html($client) ?></span>
				</div>
			<?php endif; ?>
			<?php if ( $show_location == 'true' && !empty( $location ) ) : ?> 
				<div class="content-item location">
					<span class="lbl d-block"><?php echo esc_html__( 'Location', 'adsett' ) ?>:</span>
					<span class="item-text"><?php pxl_print_html($location) ?></span>
				</div>
			<?php endif; ?>
			<?php if ( $show_project_type == 'true' && !is_wp_error( $term_list ) ) : ?> 
				<div class="content-item type">
					<span class="lbl d-block"><?php echo esc_html__( 'Project Type', 'adsett' ) ?>:</span>
					<?php the_terms( $post_id, 'portfolio-category', '', ' ' ); ?>
				</div>
			<?php endif; ?>
			<?php if ( $show_date_start == 'true' && !empty( $date_start ) ) : ?> 
				<div class="content-item date">
					<span class="lbl d-block"><?php echo esc_html__( 'Date', 'adsett' ) ?>:</span>
					<span class="item-text"><?php pxl_print_html( date('F d, Y', strtotime($date_start) )); ?></span>
				</div>
			<?php endif; ?>

		<?php endif; ?>
	</div>
</div>