<?php 
if(isset($settings['links']) && !empty($settings['links']) && count($settings['links'])): ?>
    <ul class="pxl-links d-flex flex-column layout-<?php echo esc_attr($settings['layout'])?> list-unstyled">
        <?php
            foreach ($settings['links'] as $key => $link):
                $link_key = $widget->get_repeater_setting_key( 'link', 'links', $key );
                if ( ! empty( $link['link']['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $link['link']['url'] );

                    if ( $link['link']['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $link['link']['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key );
                $active_cls = '' ;
                if( (int)$link['post_id'] > 0 ):
                    $link_post = get_the_permalink( $link['post_id'], false );
                    $current_id = get_the_ID();
                    if( (int)$link['post_id'] === $current_id)
                        $active_cls = 'active';
                ?>
                    <li class="link-item <?php echo esc_attr($active_cls)?>">
                        <a href="<?php echo esc_url($link_post)?>">
                            <span><?php pxl_print_html($link['text']); ?></span>
                        </a>
                    </li>
                <?php else: 
                    $current_id = get_the_ID();
                    $active_cls = '';
                    if( $current_id > 0 ){
                        $current_url = get_the_permalink( $current_id, false );
                        if( $link['link']['url'] == $current_url)
                            $active_cls = 'active';
                    }
                    ?>
                    <li class="link-item <?php echo esc_attr($active_cls)?>">
                        <a <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                            <span><?php pxl_print_html($link['text']); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                
        <?php endforeach; ?>
    </ul>
<?php endif; ?>
