<?php
if(!empty( $settings['link']['url'])){
    $widget->add_render_attribute( 'pxl-link', 'href', $settings['link']['url'] );
    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'pxl-link', 'target', '_blank' );
    }
    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'pxl-link', 'rel', 'nofollow' );
    }
}
if ( ! empty( $settings['link']['custom_attributes'] ) ) {
    // Custom URL attributes should come as a string of comma-delimited key|value pairs
    $custom_attributes = Elementor\Utils::parse_custom_attributes( $settings['link']['custom_attributes'] );
    $widget->add_render_attribute( 'pxl-link', $custom_attributes);
}
 
$widget->add_render_attribute( 'pxl-link', 'class', 'pxl-link '.$settings['style'].' icon-ps-'.$settings['icon_align'] );

?>
<a <?php pxl_print_html($widget->get_render_attribute_string( 'pxl-link' )); ?>>
    <span class="link-text"><?php pxl_print_html($settings['text']); ?></span>
    <?php 
    if ( $settings['pxl_icon']['value'] ) 
        \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => 'pxl-icon '.$settings['icon_align'] ], 'span' ); 
    else
        if( $settings['style'] == 'circle')
            echo '<span class="pxl-icon pxli pxli-right-arrow1"></span>';
    ?>
</a>
     
 