<?php
extract($settings);
if(count($wp_gallery) < 0) return;

$img_size = !empty( $img_size ) ? $img_size : '640x611'; 
$arrows = $widget->get_setting('arrows','false');  
$dots = $widget->get_setting('dots','false');
 
if ($gallery_rand == 'rand'){
    shuffle($wp_gallery);
}

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show_xxl'            => $widget->get_setting('col_xxl', '3'), 
    'slides_to_show'                => $widget->get_setting('col_xl', '3'), 
    'slides_to_show_lg'             => $widget->get_setting('col_lg', '3'), 
    'slides_to_show_md'             => $widget->get_setting('col_md', '2'), 
    'slides_to_show_sm'             => $widget->get_setting('col_sm', '2'), 
    'slides_to_show_xs'             => $widget->get_setting('col_xs', '2'), 
    'slides_to_scroll'              => $widget->get_setting('slides_to_scroll', '1'), 
    'slides_gutter'                 => (int)$widget->get_setting('gutter', '-1'), 
    'center_slide'                  => $widget->get_setting('center_slide', 'false'),
    'arrow'                         => $arrows,
    'dots'                          => $dots,
    'dots_style'                    => 'bullets',
    'autoplay'                      => $widget->get_setting('autoplay', 'false'),
    'pause_on_hover'                => $widget->get_setting('pause_on_hover', 'true'),
    'pause_on_interaction'          => 'true',
    'delay'                         => $widget->get_setting('autoplay_speed', '5000'),
    'loop'                          => $widget->get_setting('infinite','false'),
    'speed'                         => $widget->get_setting('speed', '500')
];
 
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
 
?>
 
<div class="pxl-swiper-slider pxl-gallery-carousel layout-<?php echo esc_attr($layout) ?>">
    <div class="pxl-swiper-slider-wrap pxl-carousel-inner overflow-hidden">
        <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
            <div class="pxl-swiper-wrapper swiper-wrapper">
                <?php 
                foreach ($wp_gallery as $key => $value):
                    $img = pxl_get_image_by_size( array(
                        'attach_id'  => $value['id'],
                        'thumb_size' => $img_size,
                        'class' => 'no-lazyload',
                    ));
                    $thumbnail = $img['thumbnail'];

                    ?>
                    <div class="pxl-swiper-slide swiper-slide">
                        <div class="item-inner relative overflow-hidden">
                            <?php if(!empty($thumbnail)) { ?>
                                <div class="item-image relative">
                                    <?php echo wp_kses_post($thumbnail); ?>
                                </div>
                            <?php } ?>
                            <div class="pxl-overlay"></div>
                            <a data-elementor-lightbox-slideshow="<?php echo esc_attr($settings['element_id']);?>" class="pxl-galleries-light-box" href="<?php echo esc_url($value['url']); ?>" data-id="<?php echo esc_attr($value['id'])?>" data-elementor-lightbox-title="<?php echo esc_attr(wp_get_attachment_caption($value['id']))?>"></a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>    
        </div>
    </div>
    <?php if($arrows !== 'false'): 
        $arrows_position_cls = !empty( $arrows_position ) ? $arrows_position : 'nav-out-vertical';
        $arrows_on_hover_cls = $arrows_on_hover == 'true' ? 'arrow-on-hover' : ''; 
        ?>
        <div class="pxl-swiper-arrows <?php echo esc_attr($arrows_position_cls) ?> <?php echo esc_attr($arrows_on_hover_cls) ?>">
            <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><span class="pxl-icon pxli-left-arrow"></span></div>
            <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><span class="pxl-icon pxli-right-arrow"></span></div>
        </div>
    <?php endif; ?>
    <?php if($dots !== 'false'): ?>
    <div class="pxl-swiper-dots"></div>
    <?php endif; ?>
</div>
 
