<?php

$widget->add_render_attribute( 'fancybox-wrap', 'class', ['pxl-fancybox-wrap', 'layout-'.$settings['layout']]);

// Heading
$widget->add_render_attribute( 'heading', 'class', 'title pxl-heading');
if ( $settings['title_animation'] ) {
    $widget->add_render_attribute( 'heading', 'class', 'pxl-animate pxl-invisible animated-'.$settings['title_animation_duration']);
    $widget->add_render_attribute( 'heading', 'data-settings', 
        json_encode([
            'animation'      => $settings['title_animation'],
            'animation_delay' => $settings['title_animation_delay']
        ])
    );
}
// desc
$widget->add_render_attribute( 'desc', 'class', 'desc');
if ( $settings['title_animation'] ) {
    $widget->add_render_attribute( 'desc', 'class', 'pxl-animate pxl-invisible animated-'.$settings['desc_animation_duration']);
    $widget->add_render_attribute( 'desc', 'data-settings', 
        json_encode([
            'animation'      => $settings['desc_animation'],
            'animation_delay' => $settings['desc_animation_delay']
        ])
    );
}

// image
$widget->add_render_attribute( 'image', 'class', 'relative');
if ( $settings['title_animation'] ) {
    $widget->add_render_attribute( 'image', 'class', 'pxl-animate pxl-invisible animated-'.$settings['img_animation_duration']);
    $widget->add_render_attribute( 'image', 'data-settings', 
        json_encode([
            'animation'      => $settings['img_animation'],
            'animation_delay' => $settings['img_animation_delay']
        ])
    );
} 

if(!empty($settings['hyper_link']['url'])){
    $href = $settings['hyper_link']['url'];
    if( strpos($settings['hyper_link']['url'], 'http') === false )
        $href = 'tel:'.$settings['hyper_link']['url'];
    $widget->add_render_attribute( 'custom_link', 'href', $href );

    if ( $settings['hyper_link']['is_external'] ) {
        $widget->add_render_attribute( 'custom_link', 'target', '_blank' );
    }

    if ( $settings['hyper_link']['nofollow'] ) {
        $widget->add_render_attribute( 'custom_link', 'rel', 'nofollow' );
    }
}

$link_attributes = $widget->get_render_attribute_string( 'custom_link' );
$link_text = $widget->get_setting( 'link_text', esc_html__( 'Call us now!','adsett' ) );
?>
 
<div <?php pxl_print_html($widget->get_render_attribute_string('fancybox-wrap'));?>>
    <div class="fancybox-inner relative">
        <?php if(!empty($widget->get_setting('title'))): ?>
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'heading' )); ?>>
                <?php pxl_print_html( nl2br($widget->get_setting('title'))); ?>
            </div>
        <?php endif; ?>
        <?php if(!empty($widget->get_setting('desc'))): ?>
        <div <?php pxl_print_html($widget->get_render_attribute_string( 'desc' )); ?>>
            <?php pxl_print_html( nl2br($widget->get_setting('desc'))); ?>
        </div>
        <?php endif; ?>
        <?php if ( $link_attributes ) echo '<a class="btn pxl-btn" '. $link_attributes .'>'.$link_text.'</a>'; ?>
    </div>  
</div>
 



