<?php

$widget->add_render_attribute( 'fancybox-wrap', 'class', ['pxl-fancybox-wrap', 'layout-'.$settings['layout']]);

// Heading
$widget->add_render_attribute( 'heading', 'class', 'title pxl-heading');
if ( $settings['title_animation'] ) {
    $widget->add_render_attribute( 'heading', 'class', 'pxl-animate pxl-invisible animated-'.$settings['title_animation_duration']);
    $widget->add_render_attribute( 'heading', 'data-settings', 
        json_encode([
            'animation'      => $settings['title_animation'],
            'animation_delay' => $settings['title_animation_delay']
        ])
    );
}
// sub title
$widget->add_render_attribute( 'sub-heading', 'class', 'sub-title');
if ( $settings['title_animation'] ) {
    $widget->add_render_attribute( 'sub-heading', 'class', 'pxl-animate pxl-invisible animated-'.$settings['sub_title_animation_duration']);
    $widget->add_render_attribute( 'sub-heading', 'data-settings', 
        json_encode([
            'animation'      => $settings['sub_title_animation'],
            'animation_delay' => $settings['sub_title_animation_delay']
        ])
    );
}

// image
$widget->add_render_attribute( 'image', 'class', 'relative');
if ( $settings['title_animation'] ) {
    $widget->add_render_attribute( 'image', 'class', 'pxl-animate pxl-invisible animated-'.$settings['img_animation_duration']);
    $widget->add_render_attribute( 'image', 'data-settings', 
        json_encode([
            'animation'      => $settings['img_animation'],
            'animation_delay' => $settings['img_animation_delay']
        ])
    );
} 

if(!empty($settings['hyper_link']['url'])){
    $widget->add_render_attribute( 'custom_link', 'href', $settings['hyper_link']['url'] );

    if ( $settings['hyper_link']['is_external'] ) {
        $widget->add_render_attribute( 'custom_link', 'target', '_blank' );
    }

    if ( $settings['hyper_link']['nofollow'] ) {
        $widget->add_render_attribute( 'custom_link', 'rel', 'nofollow' );
    }
}

$link_attributes = $widget->get_render_attribute_string( 'custom_link' );
$link_text = $widget->get_setting( 'link_text', esc_html__( 'Read Now','adsett' ) );
?>
 
<div <?php pxl_print_html($widget->get_render_attribute_string('fancybox-wrap'));?>>
    <div class="fancybox-inner relative">
        <?php if(!empty($widget->get_setting('title'))): ?>
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'heading' )); ?>>
                <?php pxl_print_html( nl2br($widget->get_setting('title'))); ?>
            </div>
        <?php endif; ?>
        <div class="fancy-image relative">
            <div class="pxl-overlay bg"></div>
            <?php if( !empty( $settings['selected_img']['url'] )): ?>
                <img <?php pxl_print_html($widget->get_render_attribute_string( 'image' )); ?> src="<?php echo esc_url($settings['selected_img']['url']); ?>">
            <?php endif; ?>
            <div class="pxl-overlay opacity"></div>
            <?php if ( $link_attributes ) echo '<a class="btn pxl-btn outline-under draw" '. $link_attributes .'><span class="draw-top-right"></span><span class="draw-bottom-left"></span>'.$link_text.'</a>'; ?>
            
        </div>
        <?php if(!empty($widget->get_setting('sub_title'))): ?>
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'sub-heading' )); ?>><?php
                pxl_print_html($widget->get_setting('sub_title'));
            ?></div>
        <?php endif; ?> 
    </div>  
</div>
 



