<?php

$widget->add_render_attribute( 'fancybox-wrap', 'class', ['pxl-fancybox-wrap d-flex-wrap w-100', 'layout-'.$settings['layout']]);

// Heading
$widget->add_render_attribute( 'heading', 'class', 'title pxl-heading');
if ( $settings['title_animation'] ) {
    $widget->add_render_attribute( 'heading', 'class', 'pxl-animate pxl-invisible animated-'.$settings['title_animation_duration']);
    $widget->add_render_attribute( 'heading', 'data-settings', 
        json_encode([
            'animation'      => $settings['title_animation'],
            'animation_delay' => $settings['title_animation_delay']
        ])
    );
}
// sub title
$widget->add_render_attribute( 'sub-heading', 'class', 'sub-title');
if ( $settings['sub_title_animation'] ) {
    $widget->add_render_attribute( 'sub-heading', 'class', 'pxl-animate pxl-invisible animated-'.$settings['sub_title_animation_duration']);
    $widget->add_render_attribute( 'sub-heading', 'data-settings', 
        json_encode([
            'animation'      => $settings['sub_title_animation'],
            'animation_delay' => $settings['sub_title_animation_delay']
        ])
    );
}

if(!empty($settings['hyper_link']['url'])){
    $widget->add_render_attribute( 'custom_link', 'href', $settings['hyper_link']['url'] );

    if ( $settings['hyper_link']['is_external'] ) {
        $widget->add_render_attribute( 'custom_link', 'target', '_blank' );
    }

    if ( $settings['hyper_link']['nofollow'] ) {
        $widget->add_render_attribute( 'custom_link', 'rel', 'nofollow' );
    }
}

$link_attributes = $widget->get_render_attribute_string( 'custom_link' );
$link_text = $widget->get_setting( 'link_text', esc_html__( 'Learn more','adsett' ) );

$is_active = $widget->get_setting( 'is_active', 'false' );
if($is_active == 'true')
    $widget->add_render_attribute( 'fancybox-wrap', 'class', 'active' );
?>
 
<div <?php pxl_print_html($widget->get_render_attribute_string('fancybox-wrap'));?>>
    <div class="fancybox-inner relative overflow-hidden w-100">
        <div class="pxl-fancybox-content relative">
            <?php if(!empty($widget->get_setting('sub_title'))): ?>
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'sub-heading' )); ?>><?php
                pxl_print_html($widget->get_setting('sub_title'));
            ?></div>
            <?php endif; ?>
            <?php if(!empty($widget->get_setting('title'))): ?>
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'heading' )); ?>>
                <?php pxl_print_html($widget->get_setting('title')); ?>
            </div>
            <?php endif; ?>
        </div> 
        <div class="row-active row gx-0 w-100">
            <div class="col-action col-12 col-md-4 relative">
                <?php if ( $link_attributes ) echo '<a class="btn" '. $link_attributes .'>'; ?>
                    <?php pxl_print_html( $link_text); ?>
                <?php if ( $link_attributes ) echo '</a>'; ?> 
            </div>
            <div class="col-img1 col-12 col-sm-6 col-md-4 relative overflow-hidden pxl-parallax-background">
                <?php if( !empty( $settings['selected_img']['url'] )): ?>
                    <div class="img-box parallax-inner" style="background-image: url('<?php echo esc_url($settings['selected_img']['url']) ?>');" ></div>
                <?php endif; ?>
            </div>
            <div class="col-img2 col-12 col-sm-6 col-md-4 relative overflow-hidden pxl-parallax-background">
                <?php if( !empty( $settings['selected_img_2']['url'] )):?>
                    <div class="img-box parallax-inner" style="background-image: url('<?php echo esc_url($settings['selected_img_2']['url']) ?>');"></div>
                <?php endif; ?>
            </div>
        </div>
        
    </div> 
</div>
 



