<?php
extract($settings);
?>
<?php if(isset($download) && !empty($download) && count($download)): ?>
    <div class="pxl-download">
        <?php foreach ($download as $key => $pxl_download):
             
            $link_key = $widget->get_repeater_setting_key( 'title', 'download', $key );
            if ( ! empty( $pxl_download['link']['url'] ) ) {
                $widget->add_render_attribute( $link_key, 'href', $pxl_download['link']['url'] );

                if ( $pxl_download['link']['is_external'] ) {
                    $widget->add_render_attribute( $link_key, 'target', '_blank' );
                }

                if ( $pxl_download['link']['nofollow'] ) {
                    $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                }
            }
            $link_attributes = $widget->get_render_attribute_string( $link_key );
            ?>
            <div class="item-download">
                <a <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                    <div class="item-wrap d-flex-wrap align-items-center">
                        <div class="item-icon col-auto">
                            <?php \Elementor\Icons_Manager::render_icon( $pxl_download['pxl_icon'], [ 'aria-hidden' => 'true','class' => 'pxl-icon' ], 'span' );?>
                        </div>
                    <div class="item-text col">
                        <span class="file-name"><?php pxl_print_html($pxl_download['title']); ?></span>
                        <?php if(!empty($pxl_download['file_size'])): ?>
                            <span class="file-size"><?php pxl_print_html($pxl_download['file_size']); ?></span>
                        <?php endif; ?>
                    </div>
                    <div class="item-icon-download col-auto">
                        <img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/download-icon.png')?>">
                    </div>
                    </div>
                </a>
           </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

