<?php
$widget->add_render_attribute( 'counter', [
    'class' => 'pxl-counter-number-value',
    'data-startnumber' => $widget->get_setting('starting_number', 0),
    'data-endnumber' => $settings['ending_number'],
] );

if ( ! empty( $settings['thousand_separator'] ) ) {
    $delimiter = empty( $settings['thousand_separator_char'] ) ? '' : $settings['thousand_separator_char'];
    $widget->add_render_attribute( 'counter', 'data-delimiter', $delimiter );
}


?>
<div class="pxl-counter layout<?php echo esc_attr($settings['layout']) ?>">
     
    <div class="counter-content d-flex-wrap align-items-center">
        <div class="counter-number col-auto">
            <?php if(isset($settings['prefix'])) : ?>
                <span class="counter-number-prefix empty-none"><?php echo pxl_print_html($settings['prefix']); ?></span>
            <?php endif; ?>
            <span <?php pxl_print_html($widget->get_render_attribute_string( 'counter' )); ?>><?php echo esc_html($settings['starting_number']); ?></span>
            <?php if(isset($settings['suffix'])) : ?>
                <span class="counter-number-suffix empty-none"><?php echo pxl_print_html($settings['suffix']); ?></span>
            <?php endif; ?>
        </div>
        <?php if ( $settings['title'] ) : ?>
            <div class="counter-title col">
                <div class="title"><?php pxl_print_html($settings['title']); ?></div> 
            </div>
        <?php endif; ?>
    </div>
     
</div>
 