<?php 
	extract($settings);
	$link_title = !empty($settings['link_title']) ? $settings['link_title'] : esc_html__( 'Get Start', 'adsett' );
	
	$widget->add_render_attribute( 'ab_link', 'href', $settings['link']['url'] );
    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'ab_link', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'ab_link', 'rel', 'nofollow' );
    }
?>
<div class="pxl-carrer-wg">
	<div class="d-flex-wrap align-items-center gx-30">
		<?php if(!empty($number)): ?>
		<div class="col-12 col-sm-auto col-number">
			<span class="number"><?php pxl_print_html($number) ?></span>
		</div>
		<?php endif; ?>
		<?php if(!empty($title)): ?>
		<div class="col-12 col-sm-4 col-title">
			<h5 class="title">
				<?php if( !empty($settings['link']['url']) ): ?>
					<a <?php pxl_print_html($widget->get_render_attribute_string( 'ab_link' )); ?>>
				<?php endif; ?>	
				<?php pxl_print_html( nl2br($title)) ?>
				<?php if( !empty($settings['link']['url']) ): ?>	
					</a>
				<?php endif; ?>	
			</h5>
			<?php if(!empty($date) || !empty($location)): ?>
				<div class="carrer-meta d-flex-wrap">
					<?php if(!empty($date)): ?>
						<span class="date"><?php pxl_print_html( $date) ?></span>
					<?php endif; ?>	
					<?php if(!empty($location)): ?>
						<span class="location"><?php pxl_print_html( $location) ?></span>
					<?php endif; ?>	
				</div>
			<?php endif; ?>	
		</div>
		<?php endif; ?>
		<?php if(!empty($desc)): ?>
			<div class="col col-desc">
				<div class="desc"><?php pxl_print_html( nl2br($desc)) ?></div>
				<?php if(!empty($time)): ?>
					<span class="time"><?php pxl_print_html($time) ?></span>
				<?php endif; ?>	
			</div>
		<?php endif; ?>	
		<?php if( !empty($settings['link']['url']) ): ?>
			<div class="col-12 col-sm-auto col-action">
				<a class="pxl-readmore-arrow" <?php pxl_print_html($widget->get_render_attribute_string( 'ab_link' )); ?>>
					<span class="pxli pxli-right-arrow1"></span>
				</a>
			</div>
		<?php endif; ?>
	</div>
</div>
 