<?php
$widget->add_render_attribute( 'wrapper', 'class', 'pxl-button-wrapper d-flex-wrap pxl-button-layout1' );
$link_type = !empty($settings['button_url_type']) ? $settings['button_url_type'] : 'url';
if(!empty( $settings['link']['url'])){
    $widget->add_render_attribute( 'button', 'href', $settings['link']['url'] );
    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }
    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
}
if ( ! empty( $settings['link']['custom_attributes'] ) ) {
    // Custom URL attributes should come as a string of comma-delimited key|value pairs
    $custom_attributes = Elementor\Utils::parse_custom_attributes( $settings['link']['custom_attributes'] );
    $widget->add_render_attribute( 'button', $custom_attributes);
}

$border_hover_style = !empty($settings['border_hover_style']) ? $settings['border_hover_style'] : 'transform';

$widget->add_render_attribute( 'button', 'class', 'pxl-btn '.$settings['style'].' '.$border_hover_style.' icon-ps-'.$settings['icon_align'].' '.$settings['in_dark'] );


if ( ! empty( $settings['button_css_id'] ) ) {
    $widget->add_render_attribute( 'button', 'id', $settings['button_css_id'] );
}


$html_id = pxl_get_element_id($settings);


if(!empty($settings['pxl_parallax'])){
    $parallax_settings = json_encode([
        $settings['pxl_parallax'] => $settings['parallax_value']
    ]);
    $widget->add_render_attribute( 'wrapper', 'data-parallax', $parallax_settings );
}


 
?>
<div id="<?php echo esc_attr($html_id); ?>" <?php pxl_print_html($widget->get_render_attribute_string( 'wrapper' )); ?> >
    <?php if($settings['style'] == 'round-circle'): ?>
        <a class="pxl-readmore-round-arrow" href="<?php echo esc_url($settings['link']['url']) ?>">
            <?php 
            if ( $settings['btn_icon']['value'] ) 
                \Elementor\Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true', 'class' => 'pxl-button-icon pxl-icon '.$settings['icon_align'] ], 'span' ); 
            else
                echo '<span class="pxl-icon pxli pxli-right-arrow1"></span>';
            ?>
            <span class="pxl-button-text rm-text"><?php echo esc_html($settings['text']); ?></span>
        </a>
    <?php else: ?>
        <a <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?>>
            <?php if($border_hover_style == 'draw'): ?> 
                <span class="draw-top-right"></span>
                <span class="draw-bottom-left"></span>
            <?php endif; ?>
            <?php
    		//$widget->add_inline_editing_attributes( 'text', 'none' ); ?>
            <span class="pxl-button-text"><?php echo esc_html($settings['text']); ?></span>
            <?php 
            if ( $settings['btn_icon'] ) 
                \Elementor\Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true', 'class' => 'pxl-button-icon pxl-icon '.$settings['icon_align'] ], 'span' ); 
            ?>
        </a>
    <?php endif; ?>
</div>