<?php 

extract($settings);
 
if ( ! empty( $link['url'] ) ) {
    $widget->add_render_attribute( 'link', 'href', $link['url'] );

    if ( $link['is_external'] ) {
        $widget->add_render_attribute( 'link', 'target', '_blank' );
    }

    if ( $link['nofollow'] ) {
        $widget->add_render_attribute( 'link', 'rel', 'nofollow' );
    }
}
$img_size = !empty( $img_size ) ? $img_size : 'full'; 
$thumbnail    = '';
 
if(!empty($selected_img['id'])){
    $img  = pxl_get_image_by_size( array(
        'attach_id'  => $selected_img['id'],
        'thumb_size' => $img_size,
    ) );
    $thumbnail    = $img['thumbnail'];
}
 
?>
<div class="pxl-banner layout-2">
    <div class="banner-inner relative overflow-hidden pxl-parallax-background">
        <?php if( !empty( $selected_img['url'] )):
            echo wp_kses_post($thumbnail); ?>
            <div class="img-box parallax-inner" style="background-image: url('<?php echo esc_url($selected_img['url']) ?>');" ></div>
        <?php endif; ?>
        <div class="pxl-overlay"></div>
        <div class="bn-content text-center absolute">
            <?php if ( ! empty( $link['url'] ) ): ?>
                <a <?php pxl_print_html($widget->get_render_attribute_string( 'link' )); ?>>
            <?php endif; ?>
            <?php if(!empty($title)): ?>
                <div class="bn-title" data-parallax='{"y": -30}'><?php pxl_print_html($title) ?></div>
            <?php endif; ?> 
            <?php if ( ! empty( $link['url'] ) ): ?>
                </a>
            <?php endif; ?>
        </div>
    </div>
</div>