<?php
$template = (int)$widget->get_setting('template','0');
 
$widget->add_render_attribute('anchor', 'class', 'pxl-anchor side-panel d-flex-wrap align-items-center');
 

$target = '.pxl-hidden-template-'.$template; 
if($template > 0 ){
	 
	if ( !has_action( 'pxl_anchor_target_hidden_panel_'.$template) ){
		add_action( 'pxl_anchor_target_hidden_panel_'.$template, 'adsett_hook_anchor_hidden_panel' );
	} 
	
}else if( $template == 0 && !empty($settings['link']['url'])){
	$widget->add_render_attribute( 'custom_link', 'class', 'custom-link pxl-anchor' ); 
	if( strpos($settings['link']['url'], '#') !== false){
		$widget->add_render_attribute( 'custom_link', 'class', 'anchor' ); 
		$widget->add_render_attribute( 'custom_link', 'href', 'javascript:void(0);' );
		$widget->add_render_attribute( 'custom_link', 'data-target', $settings['link']['url'] );
	}else{
		$widget->add_render_attribute( 'custom_link', 'href', $settings['link']['url'] );
	    if ( $settings['link']['is_external'] ) {
	        $widget->add_render_attribute( 'custom_link', 'target', '_blank' );
	    }
	    if ( $settings['link']['nofollow'] ) {
	        $widget->add_render_attribute( 'custom_link', 'rel', 'nofollow' );
	    }
	}
}

$custom_cls = $widget->get_setting('custom_class','');

 
?>
<div class="pxl-anchor-wrap d-flex-wrap align-items-center align-content-center <?php echo esc_attr($custom_cls); ?>">
	<?php if( $template == 0 && !empty($settings['link']['url'])): ?>
		<a <?php pxl_print_html($widget->get_render_attribute_string( 'custom_link' )); ?>>
			<?php 
		    if( $widget->get_setting('icon_type','none') == 'lib'){
		    	echo '<div class="pxl-anchor-icon d-inline-flex">';
		    	\Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'span' );
		    	echo '</div>';
		    }
		    if($widget->get_setting('icon_type','none') == 'custom-1'){
		    	echo '<div class="pxl-anchor-icon icon-custom d-inline-flex custom-1"><span></span><span></span><span></span></div>';
		    } 
		    if($widget->get_setting('icon_type','none') == 'custom-2'){
		    	echo '<div class="pxl-anchor-icon icon-custom d-inline-flex custom-2">
		    	<span class="hover top"></span>
		    	<span class="hover bottom"></span>
		    	<span class="default top"></span>
		    	<span class="default bottom"></span>
		    	</div>';
		    } 
		    if(!empty($widget->get_setting('title',''))){
		    	echo '<span class="anchor-title d-inline-flex">'.$widget->get_setting('title', '').'</span>';
		    } ?>
		</a>
	<?php else: ?>
		<div <?php pxl_print_html($widget->get_render_attribute_string( 'anchor' )); ?> data-target="<?php echo esc_attr($target)?>">
		    <?php 
		    if( $widget->get_setting('icon_type','none') == 'lib'){
		    	echo '<div class="pxl-anchor-icon d-inline-flex">';
		    	\Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'span' );
		    	echo '</div>';
		    }
		    if($widget->get_setting('icon_type','none') == 'custom-1'){
		    	echo '<div class="pxl-anchor-icon icon-custom d-inline-flex custom-1"><span></span><span></span><span></span></div>';
		    } 
		    if($widget->get_setting('icon_type','none') == 'custom-2'){
		    	echo '<div class="pxl-anchor-icon icon-custom d-inline-flex custom-2">
		    	<span class="hover top"></span>
		    	<span class="hover bottom"></span>
		    	<span class="default top"></span>
		    	<span class="default bottom"></span>
		    	</div>';
		    } 
		    if($widget->get_setting('icon_type','none') == 'custom-3'){
		    	echo '<div class="pxl-anchor-icon icon-custom d-inline-flex custom-3"><span></span><span></span><span></span></div>';
		    } 
		    if(!empty($widget->get_setting('title',''))){
		    	echo '<span class="anchor-title d-inline-flex">'.$widget->get_setting('title', '').'</span>';
		    } ?>
		</div>
	<?php endif; ?>
</div>
 