<?php 
	$link_title = !empty($settings['link_title']) ? $settings['link_title'] : esc_html__( 'Get Start', 'adsett' );
	
	$widget->add_render_attribute( 'ab_link', 'href', $settings['link']['url'] );
    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'ab_link', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'ab_link', 'rel', 'nofollow' );
    }
?>
<div class="pxl-about-wg">
	<div class="d-flex-wrap align-items-center gx-30">
		<div class="col-12 col-md-6">
			<div class="heading-wrap">
				<?php if(!empty($settings['sub-title'])): ?>
					<span class="sub-title font-heading"><?php pxl_print_html($settings['sub-title']) ?></span>
				<?php endif; ?>
				<?php if(!empty($settings['title'])): ?>
					<span class="title font-heading h2"><?php pxl_print_html( nl2br($settings['title'])) ?></span>
				<?php endif; ?>
			</div>
		</div>
		<div class="col-12 col-md-6">
			<div class="content-wrap">
				<?php if(!empty($settings['desc'])): ?>
					<div class="desc"><?php pxl_print_html( nl2br($settings['desc'])) ?></div>
				<?php endif; ?>
				<?php if( !empty($settings['link']['url']) ): ?>
					<a class="pxl-readmore ab-link" <?php pxl_print_html($widget->get_render_attribute_string( 'ab_link' )); ?>>
						<span class="btn-lbls">
							<span><?php pxl_print_html($link_title) ?></span>
	                        <span><?php pxl_print_html($link_title) ?></span>
						</span>
						<span class="btn-icons"><span class="pxli pxli-right-arrow1"></span></span>
					</a>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
 