<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;

pxl_add_custom_widget(
    array(
        'name' => 'pxl_video',
        'title' => esc_html__('PXL Video', 'adsett'),
        'icon' => 'eicon-play',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'layout_section',
                    'label' => esc_html__('Layout', 'adsett'),
                    'tab' => 'layout',
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'adsett'),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'adsett'),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_video-1.jpg'
                                ], 
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'adsett'),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_video-2.jpg'
                                ] 
                            ],
                            'prefix_class' => 'pxl-video-layout-'
                        ),

                        array(
                            'name'  => 'max_width',
                            'label' => esc_html__( 'Max Width (px)', 'adsett' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 100,
                                    'max' => 1920,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player' => 'max-width: {{SIZE}}{{UNIT}};'
                            ],
                            'separator' => 'before'
                        ),
                        array(
                            'name' => 'video_spacing',
                            'label' => esc_html__('Padding (px)', 'adsett' ),
                            'type' => 'dimensions',
                            'default' => ['top' => '', 'right' => '', 'bottom' => '', 'left' => ''],
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),
                    )
                ),
                array(
                    'name' => 'video_section',
                    'label' => esc_html__('Video', 'adsett'),
                    'tab' => 'content',
                    'controls' => array_merge(
                        array(
                            array(
                                'name' => 'video_bt_style',
                                'label' => esc_html__('Video Button Style', 'adsett'),
                                'type' => Controls_Manager::SELECT,
                                'options' => [
                                    'df' => esc_html__('Default', 'adsett'),
                                    '1' => esc_html__('Round Background', 'adsett'),
                                ],
                                'default' => 'df',
                                'condition' => ['layout' => '1']
                            ),
                            array(
                                'name' => 'video_link',
                                'label' => esc_html__('Video URL', 'adsett'),
                                'description' => '(https://www.youtube.com/watch?v=r2YbkyYA9Gc)',
                                'type' => Controls_Manager::URL,
                                'default' => [
                                    'url' => '',
                                    'is_external' => 'on'
                                ]
                            ),
                            array(
                                'name' => 'video_text',
                                'label' => esc_html__('Text', 'adsett'),
                                'type' => Controls_Manager::TEXT,
                                'default' => 'See Demo',
                                'condition' => ['layout' => ['2']]
                            ),
                            array(
                                'name' => 'video_bg_image',
                                'label' => esc_html__('Background Image', 'adsett'),
                                'type' => 'media',
                                'dynamic' => [
                                    'active' => true,
                                ],
                                'default' => [
                                    'url' => Utils::get_placeholder_image_src()
                                ],
                                'condition' => ['layout' => ['1']]
                            ),
                            array(
                                'name' => 'bg_color',
                                'label' => esc_html__('Background Color', 'adsett'),
                                'type' => 'color',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-player .pxl-overlay' => 'background-color:{{VALUE}};'
                                ]
                            ),
                             
                            array(
                                'name' => 'video_play_bg',
                                'label' => esc_html__('Video Button Background', 'adsett'),
                                'type' => Controls_Manager::COLOR,
                                'condition' => [
                                    'video_link[url]!' => ''
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-player .pxl-video-btn' => 'background-color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'video_play_bg_hover',
                                'label' => esc_html__('Video Button Background Hover', 'adsett'),
                                'type' => Controls_Manager::COLOR,
                                'condition' => [
                                    'video_link[url]!' => ''
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-player .pxl-video-btn:hover' => 'background-color: {{VALUE}};',
                                ],
                            ),
                            
                            array(
                                'name' => 'play_icon_color',
                                'label' => esc_html__('Play Icon Color', 'adsett'),
                                'type' => Controls_Manager::COLOR,
                                'condition' => [
                                    'video_link[url]!' => ''
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-player .pxl-video-btn > .pxl-icon' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'play_icon_color_hover',
                                'label' => esc_html__('Play Icon Color Hover', 'adsett'),
                                'type' => Controls_Manager::COLOR,
                                'condition' => [
                                    'video_link[url]!' => ''
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-player .pxl-video-btn:hover > .pxl-icon' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'video_play_bg_shadow',
                                'label' => esc_html__('Shadow Background Hover', 'adsett'),
                                'type' => Controls_Manager::COLOR,
                                'condition' => [
                                    'layout' => ['2'],
                                    'video_link[url]!' => ''
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-player.layout-2 .pxl-video-btn:hover' => '-webkit-box-shadow: 0 0 0 10px {{VALUE}}; box-shadow: 0 0 0 10px {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'video_animation',
                                'label' => esc_html__('Button Video Effect', 'adsett'),
                                'type' => Controls_Manager::ANIMATION,
                                'condition' => [
                                    'video_link[url]!' => ''
                                ]
                            ),
                            array(
                                'name' => 'video_animation_duration',
                                'label' => esc_html__('Animation Duration', 'adsett'),
                                'type' => Controls_Manager::SELECT,
                                'default' => 'normal',
                                'options' => [
                                    'slow' => esc_html__('Slow', 'adsett'),
                                    'normal' => esc_html__('Normal', 'adsett'),
                                    'fast' => esc_html__('Fast', 'adsett'),
                                ],
                                'condition' => [
                                    'video_link[url]!' => '',
                                    'video_animation!' => '',
                                ]
                            ),
                            array(
                                'name' => 'video_animation_delay',
                                'label' => esc_html__('Animation Delay', 'adsett'),
                                'type' => Controls_Manager::NUMBER,
                                'min' => 0,
                                'step' => 100,
                                'condition' => [
                                    'video_link[url]!' => '',
                                    'video_animation!' => ''
                                ]
                            )
                        )
                    )
                ) 
            )
        )
    ),
    adsett_get_class_widget_path()
);