<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_title_effect',
        'title' => esc_html__('PXL Title Effect', 'adsett' ),
        'icon' => 'eicon-heading',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'title',
                            'label' => esc_html__('Title', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'label_block' => true,
                        ),
                        array(
                          'name' => 'align',
                            'label' => esc_html__( 'Alignment', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'adsett' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'adsett' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'adsett' ),
                                    'icon' => 'eicon-text-align-right',
                                ],
                                'justify' => [
                                    'title' => esc_html__( 'Justified', 'adsett' ),
                                    'icon' => 'eicon-text-align-justify',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-title-effect' => 'text-align: {{VALUE}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_title',
                    'label' => esc_html__('Title', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'color_type',
                            'label' => esc_html__('Color Type', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'color' => 'Color',
                                'gradient' => 'Gradient',
                            ],
                            'default' => 'gradient',
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-title-effect .pxl-item-title' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'color_type' => ['color'],
                            ],
                        ),
                        array(
                            'name'         => 'gradient_color',
                            'label' => esc_html__( 'Background Type', 'adsett' ),
                            'type'         => \Elementor\Group_Control_Background::get_type(),
                            'control_type' => 'group',
                            'types' => [ 'gradient' ],
                            'selector'     => '{{WRAPPER}} .pxl-title-effect.pxl-type-gradient .pxl-item-title',
                            'condition' => [
                                'color_type' => ['gradient'],
                            ],
                        ),
                        array(
                            'name'         => 'title_box_shadow',
                            'label' => esc_html__( 'Title Shadow', 'adsett' ),
                            'type'         => \Elementor\Group_Control_Text_Shadow::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-title-effect .pxl-item-title',
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-title-effect .pxl-item-title',
                        ),
                        array(
                            'name' => 'white_space',
                            'label' => esc_html__('White Space', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'normal' => 'Normal',
                                'nowrap' => 'NoWrap',
                            ],
                            'default' => 'normal',
                            'selectors' => [
                                '{{WRAPPER}} {{WRAPPER}} .pxl-title-effect .pxl-item-title' => 'white-space: {{VALUE}};'
                            ],
                        ),
                        array(
                            'name' => 'title_opacity',
                            'label' => esc_html__('Opacity', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'default' => [
                                'size' => 1,
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1,
                                    'step' => 0.1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-title-effect .pxl-item-title' => 'opacity: {{SIZE}};',
                            ],
                        ),
                        array(
                            'name' => 'text_effect',
                            'label' => esc_html__('Text Effect', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'no-effect' => 'None',
                                'scroll-parallax' => 'Scroll Parallax',
                                'pxl-slide-to-left' => 'Slide Right To Left',
                                'pxl-slide-to-right' => 'Slide Left To Right',
                            ],
                            'default' => 'no-effect',
                        ),
                        array(
                            'name' => 'effect_speed',
                            'label' => esc_html__('Effect Speed', 'adsett'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'description' => 'Default: 10000ms - Unit: ms, or 8s',
                            'default' => '5s',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-title-effect .pxl-item-title' => 'animation-duration: {{VALUE}};',
                            ],
                            'condition' => [
                                'text_effect' => ['pxl-slide-to-left', 'pxl-slide-to-right'],
                            ],
                        ),
                       /* array(
                            'name' => 'text_offset_left',
                            'label' => esc_html__('Text Offset Left', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => -1000,
                                    'max' => 1000,
                                ],
                            ],
                            'default' => [
                                'size' => 500,
                            ],
                            'condition' => [
                                'text_effect' => ['scroll-parallax'],
                            ],
                        ),
                        array(
                            'name' => 'text_margin_left',
                            'label' => esc_html__('Text Margin Left', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => -1000,
                                    'max' => 1000,
                                ],
                            ],
                            'default' => [
                                'size' => -400,
                            ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-title-effect .pxl-item-title' => 'margin-left: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'text_effect' => ['scroll-parallax'],
                            ],
                        ),*/
                    ),
                ),
                adsett_elementor_animation_opts(),
            ),
        ),
    ),
    adsett_get_class_widget_path()
);