<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_text_image',
        'title' => esc_html__('PXL Text Image', 'adsett'),
        'icon' => 'eicon-nav-menu',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'adsett' ),
                    'tab'      => 'layout',
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Layout', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl-text-img1.jpg'
                                ],
                                 
                            ],
                            'prefix_class' => 'pxl-text-image-',
                        ),
                        array(
                            'name' => 'text_align',
                            'label' => esc_html__('Alignment', 'adsett' ),
                            'type' => 'choose',
                            'control_type' => 'responsive',
                            'options' => [
                                'start' => [
                                    'title' => esc_html__( 'Start', 'adsett' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'adsett' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'end' => [
                                    'title' => esc_html__( 'End', 'adsett' ),
                                    'icon' => 'eicon-text-align-right',
                                ]
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-text-img-wrap' => 'justify-content: {{VALUE}};',
                                '{{WRAPPER}} .pxl-text-img-wrap' => 'text-align: {{VALUE}};',
                            ],
                            'separator' => 'before'
                        ),
                        array(
                            'name'  => 'max_width',
                            'label' => esc_html__( 'Max Width', 'adsett' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 100,
                                    'max' => 1920,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-text-img-wrap' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                    )
                ),
                array(
                    'name' => 'section_list',
                    'label' => esc_html__('Content', 'adsett'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'content_list',
                            'label' => esc_html__('Content List', 'adsett'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'sub_title',
                                    'label' => esc_html__('Sub Title', 'adsett'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'adsett'),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'adsett'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Image', 'adsett' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ), 
                            ),
                            'title_field' => '{{{ title }}}',
                        ),
                         
                        array(
                            'name'  => 'image_width',
                            'label' => esc_html__( 'Lightbox Width', 'adsett' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 800,
                                    'step' => 1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 430,
                            ],
                            'selectors' => [
                              '{{WRAPPER}} .pxl-imgs-hover' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                             
                        ),
                        array(
                            'name'  => 'image_height',
                            'label' => esc_html__( 'Lightbox Height', 'adsett' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 800,
                                    'step' => 1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 570,
                            ],
                            'selectors' => [
                              '{{WRAPPER}} .pxl-imgs-hover' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'style_section',
                    'label' => esc_html__('Style', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array_merge(
                        array(
                            array(
                                'name' => 'sub_title_color',
                                'label' => esc_html__('Sub Title Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .sub-title' => 'color: {{VALUE}};',
                                ],
                            ),
                             
                            array(
                                'name' => 'title_color',
                                'label' => esc_html__('Title Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .title' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'sub_title_typography',
                                'label' => esc_html__('Sub Title Typography', 'adsett' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .sub-title',
                            ),
                            array(
                                'name' => 'title_typography',
                                'label' => esc_html__('Title Typography', 'adsett' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .title',
                            ),
                             
                        ),
                        adsett_elementor_animation_opts([
                            'name'   => 'item',
                            'label' => esc_html__('Item', 'adsett' ),
                        ])
                    ),
                ),
            ),
        ),
    ),
    adsett_get_class_widget_path()
);