<?php
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
$text_columns = range( 1, 10 );
$text_columns = array_combine( $text_columns, $text_columns );
$text_columns[''] = esc_html__( 'Default', 'adsett' );
pxl_add_custom_widget(
    [
        'name' => 'pxl_text_editor',
        'title' => esc_html__( 'PXL Text Editor', 'adsett' ),
        'icon' => 'eicon-text',
        'categories' => ['pxltheme-core'],
        'params' => [
            'sections' => [
                [
                    'name' => 'editor_section',
                    'label' => esc_html__( 'Text Editor', 'adsett' ),
                    'tab' => Controls_Manager::TAB_CONTENT,
                    'controls' => [
                        [
                            'name' => 'text_editor',
                            'label' => '',
                            'type' => Controls_Manager::WYSIWYG,
                            'default' => esc_html__( 'Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'adsett' ),
                        ],
                    ],
                ],
                [
                    'name' => 'section_style_content',
                    'label' => esc_html__( 'Style', 'adsett' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                    'controls' => [
                        [
                            'name'  => 'max_width',
                            'label' => esc_html__( 'Max Width (px)', 'adsett' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 100,
                                    'max' => 1920,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-text-editor' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ],
                        [
                          'name' => 'align',
                            'label' => esc_html__( 'Alignment', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'start' => [
                                    'title' => esc_html__( 'Left', 'adsett' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'adsett' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'end' => [
                                    'title' => esc_html__( 'Right', 'adsett' ),
                                    'icon' => 'eicon-text-align-right',
                                ]
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-text-editor-wrap' => 'justify-content: {{VALUE}};',
                                '{{WRAPPER}} .pxl-text-editor' => 'text-align: {{VALUE}};',
                            ],
                        ],
                        [
                            'name' => 'text_color',
                            'label' => esc_html__( 'Text Color', 'adsett' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '',
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-text-editor' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .border-left .pxl-text-editor:before' => 'background-color: {{VALUE}};',
                            ],
                        ],
                        [
                            'name' => 'link_color',
                            'label' => esc_html__( 'Link Color', 'adsett' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-text-editor a' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-text-editor a.link-underline' => 'border-color: {{VALUE}};',
                            ],
                        ],
                        [
                            'name' => 'link_color_hover',
                            'label' => esc_html__( 'Link Color Hover', 'adsett' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-text-editor a:hover' => 'color: {{VALUE}};',
                            ],
                        ],
                        [
                            'name' => 'typography',
                            'type' => Group_Control_Typography::get_type(),
                            'label' => esc_html__( 'Text Typography', 'adsett' ),
                            'selector' => '{{WRAPPER}} .pxl-text-editor, {{WRAPPER}} .pxl-text-editor h1, {{WRAPPER}} .pxl-text-editor h2, {{WRAPPER}} .pxl-text-editor h3, {{WRAPPER}} .pxl-text-editor h4, {{WRAPPER}} .pxl-text-editor h5, {{WRAPPER}} .pxl-text-editor h6',
                            'control_type' => 'group',
                        ],
                        [
                            'name' => 'link_typography',
                            'type' => Group_Control_Typography::get_type(),
                            'label' => esc_html__( 'Link Typography', 'adsett' ),
                            'selector' => '{{WRAPPER}} .pxl-text-editor a',
                            'control_type' => 'group',
                        ],
                        [
                            'name' => 'border_left',
                            'label' => esc_html__('Border Left', 'adsett'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ],
                    ],
                ],
                [
                    'name' => 'stroke_section',
                    'label' => esc_html__('Stroke Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => [
                        [
                            'name' => 'text_stroke',
                            'label' => esc_html__('Text Stroke', 'adsett'),
                            'type' => \Elementor\Controls_Manager::SWITCHER
                        ],
                        [
                            'name' => 'text_stroke_width',
                            'label' => esc_html__('Text Stroke Width', 'adsett'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-text-editor' => '-webkit-text-stroke-width: {{VALUE}}px;',
                            ],
                            'default' => '',
                            'condition' => ['text_stroke' => 'true']
                        ],
                        [
                            'name' => 'stroke_color',
                            'label' => esc_html__( 'Stroke Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-text-editor' => '-webkit-text-stroke-color: {{VALUE}};',
                            ],
                            'condition' => ['text_stroke' => 'true']
                        ],
                    ]
                ],
                [
                    'name' => 'parallax_section',
                    'label' => esc_html__('Parallax Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => [
                        [
                            'name' => 'pxl_parallax',
                            'label' => esc_html__( 'Parallax Type', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                ''        => esc_html__( 'None', 'adsett' ),
                                'x'       => esc_html__( 'Transform X', 'adsett' ),
                                'y'       => esc_html__( 'Transform Y', 'adsett' ),
                                'z'       => esc_html__( 'Transform Z', 'adsett' ),
                                'rotateX' => esc_html__( 'RotateX', 'adsett' ),
                                'rotateY' => esc_html__( 'RotateY', 'adsett' ),
                                'rotateZ' => esc_html__( 'RotateZ', 'adsett' ),
                                'scaleX'  => esc_html__( 'ScaleX', 'adsett' ),
                                'scaleY'  => esc_html__( 'ScaleY', 'adsett' ),
                                'scaleZ'  => esc_html__( 'ScaleZ', 'adsett' ),
                                'scale'   => esc_html__( 'Scale', 'adsett' ),
                            ],
                        ],
                        [
                            'name' => 'parallax_value',
                            'label' => esc_html__('Value', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '',
                            'condition' => [ 'pxl_parallax!' => '']  
                        ],
                    ]
                ]
            ],
        ],
    ],
    adsett_get_class_widget_path()
);