<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_team',
        'title' => esc_html__('PXL Team', 'adsett'),
        'icon' => 'eicon-user-circle-o',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'layout_section',
                    'label' => esc_html__('Layout', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Layout', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_team-1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__( 'Layout 2', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_team-2.jpg'
                                ],
                                '3' => [
                                    'label' => esc_html__( 'Layout 3', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_team-3.jpg'
                                ],
                                '4' => [
                                    'label' => esc_html__( 'Layout 4', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_team-4.jpg'
                                ],
                            ],
                            'prefix_class' => 'pxl-team-layout-',
                        ),
                    ),
                ),
                array(
                    'name' => 'content_section',
                    'label' => esc_html__('Content', 'adsett'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'image',
                            'label' => esc_html__('Image', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        array(
                            'name' => 'title',
                            'label' => esc_html__('Title', 'adsett'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'position',
                            'label' => esc_html__('Position', 'adsett'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'condition' => ['layout' => ['1','2','4']]
                        ),
                        array(
                            'name' => 'desc',
                            'label' => esc_html__('Description', 'adsett'),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'condition' => ['layout' => ['3','4']]
                        ),
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'adsett'),
                            'type' => \Elementor\Controls_Manager::URL,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'link_title',
                            'label' => esc_html__('Link Title', 'adsett'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'condition' => ['layout' => ['1']]
                        ),
                        array(
                            'name' => 'social',
                            'label' => esc_html__( 'Social (layout 1, 4)', 'adsett' ),
                            'type' => 'pxl_icons',
                        )
                    ),
                ),
                array(
                    'name' => 'style_section',
                    'label' => esc_html__('Style', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' =>  esc_html__('Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).', 'adsett')
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-team-wg.layout-1 .item-title' => 'color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => ['1']]
                        ),
                        array(
                            'name' => 'position_color',
                            'label' => esc_html__('Position Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-team-wg .item-position' => 'color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => ['1','2','4']]
                        ),
                        array(
                            'name' => 'bg_overlay',
                            'label' => esc_html__('Background Overlay', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-team-wg.layout-1 .pxl-overlay' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => ['1']]
                        ),
                        array(
                            'name' => 'content_bg',
                            'label' => esc_html__('Background Content', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-team-wg.layout-1 .item-content' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => ['1']]
                        ),
                        array(
                            'name' => 'content_padding',
                            'label' => esc_html__('Content Padding', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-team-wg.layout-1 .item-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'condition' => ['layout' => ['1']]
                        ),
                        array(
                            'name' => 'border_color',
                            'label' => esc_html__('Border Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-team-wg.layout-3 .pxl-team-inner:before, {{WRAPPER}} .pxl-team-wg.layout-3 .bg-middle, {{WRAPPER}} .pxl-team-wg.layout-3 .pxl-team-inner:after' => 'border-color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => ['3']]
                        ),
                        array(
                            'name' => 'css_filters',
                            'label' => esc_html__('CSS Filters', 'adsett' ),
                            'type' => \Elementor\Group_Control_Css_Filter::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-team-wg .item-image img',
                            'condition' => ['layout' => ['4']]
                        ),
                    ),
                ),
                array(
                    'name' => 'parallax_section',
                    'label' => esc_html__('Parallax Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => [
                        [
                            'name' => 'pxl_parallax',
                            'label' => esc_html__( 'Parallax Type', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                ''        => esc_html__( 'None', 'adsett' ),
                                'x'       => esc_html__( 'Transform X', 'adsett' ),
                                'y'       => esc_html__( 'Transform Y', 'adsett' ),
                                'z'       => esc_html__( 'Transform Z', 'adsett' ),
                                'rotateX' => esc_html__( 'RotateX', 'adsett' ),
                                'rotateY' => esc_html__( 'RotateY', 'adsett' ),
                                'rotateZ' => esc_html__( 'RotateZ', 'adsett' ),
                                'scaleX'  => esc_html__( 'ScaleX', 'adsett' ),
                                'scaleY'  => esc_html__( 'ScaleY', 'adsett' ),
                                'scaleZ'  => esc_html__( 'ScaleZ', 'adsett' ),
                                'scale'   => esc_html__( 'Scale', 'adsett' ),
                            ],
                        ],
                        [
                            'name' => 'parallax_value',
                            'label' => esc_html__('Value', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '',
                            'condition' => [ 'pxl_parallax!' => '']  
                        ],
                    ]
                )
            ),
        ),
    ),
    adsett_get_class_widget_path()
);