<?php
pxl_add_custom_widget(
    array(
		'name'       => 'pxl_socials',
		'title'      => esc_html__( 'PXL Social', 'adsett' ),
		'icon'       => 'eicon-social-icons',
		'categories' => array('pxltheme-core'),
		'scripts'    => array(),
		'params'     => array(
            'sections' => array(
                array(
					'name'     => 'layout_section',
					'label'    => esc_html__( 'Layout', 'adsett' ),
					'tab'      => 'layout',
					'controls' => array(
                        array(
							'name'    => 'layout',
							'label'   => esc_html__( 'Templates', 'adsett' ),
							'type'    => 'layoutcontrol',
							'default' => '1',
							'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_socials-1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__( 'Layout 2', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_socials-2.jpg'
                                ],  
                                '3' => [
                                    'label' => esc_html__( 'Layout 3', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_socials-3.jpg'
                                ] 
                            ],
                            'prefix_class' => 'pxl-socials-layout-'
                        ),
                    ),
                ),
                array(
					'name'     => 'social_section',
					'label'    => esc_html__( 'Socials Settings', 'adsett' ),
					'tab'      => 'content',
					'controls' => array(
						
                        array(
							'name'     => 'social_list',
							'label'    => esc_html__( 'Social Lists', 'adsett' ),
							'type'     => 'repeater',
							'controls' => array_merge(
								array(
	                                array(
										'name'        => 'social_name',
										'label'       => esc_html__( 'Name', 'adsett' ),
										'type'        => 'text',
										'label_block' => true,
	                                ),
	                                array(
										'name'        => 'social_link',
										'label'       => esc_html__( 'Link', 'adsett' ),
										'type'        => 'url',
										'placeholder' => esc_html__('https://your-link.com', 'adsett' ),
										'label_block' => true,
	                                ),
	                                array(
										'name'             => 'social_icon',
										'label'            => esc_html__( 'Icon', 'adsett' ),
										'type'             => 'icons',
										'fa4compatibility' => 'social',
										'default'          => [],
			                        )
	                            )
                            ),
                            'default' => [
                                [
                                    'social_name' => 'Facebook',
                                    'social_link' => [
                                        'url'         => 'https://facebook.com',
                                        'is_external' => 'on'
                                    ],
                                    'social_icon' => [
                                        'value'   => 'pxli-facebook-f',
                                        'library' => 'pxli',
                                    ]
                                ],
                                [
                                    'social_name' => 'Twitter',
                                    'social_link' => [
                                        'url'         => 'https://twitter.com',
                                        'is_external' => 'on'
                                    ],
                                    'social_icon' => [
                                        'value'   => 'pxli-twitter',
                                        'library' => 'pxli',
                                    ]
                                ],
                                [
                                    'social_name' => 'Linkedin',
                                    'social_link' => [
                                        'url'         => 'https://linkedin.com',
                                        'is_external' => 'on'
                                    ],
                                    'social_icon' => [
                                        'value'   => 'pxli-linkedin-in',
                                        'library' => 'pxli',
                                    ]
                                ],
                                [
                                    'social_name' => 'Pinterest',
                                    'social_link' => [
                                        'url'         => 'https://pinterest.com',
                                        'is_external' => 'on'
                                    ],
                                    'social_icon' => [
                                        'value'   => 'pxli-pinterest-p',
                                        'library' => 'pxli',
                                    ]
                                ]
                            ],
                            'title_field' => '{{{ elementor.helpers.renderIcon( this, social_icon, {}, "i", "panel" ) || \'<i class="{{ icon }}" aria-hidden="true"></i>\' }}} {{{ social_name }}}'
                        ),
					     
                    )
                ),
                array(
                    'name' => 'style_section',
                    'label' => esc_html__('Style', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name'         => 'align',
                            'label'        => esc_html__( 'Alignment', 'adsett' ),
                            'type'         => 'choose',
                            'control_type' => 'responsive',
                            'default'      => '',
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'adsett' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'adsett' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'adsett' ),
                                    'icon' => 'eicon-text-align-right',
                                ]
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-socials-wrap' => 'text-align: {{VALUE}};'
                            ],
                        ),
                        array(
                            'name' => 'social_item_space',
                            'label' => esc_html__('Item Space', 'adsett' ),
                            'type' => 'slider',
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-socials-wrap' => 'margin-left: calc({{SIZE}}{{UNIT}} / -2); margin-right: calc({{SIZE}}{{UNIT}} / -2);',
                                '{{WRAPPER}} .pxl-socials-wrap >*' => 'margin-left: calc({{SIZE}}{{UNIT}} / 2); margin-right: calc({{SIZE}}{{UNIT}} / 2);',
                            ],
                        ),
                        array(
                            'name'  => 'social_icon_size',
                            'label' => esc_html__( 'Icon Font Size', 'adsett' ),
                            'type'  => 'slider',
                            'range' => [
                                'px' => [
                                    'min' => 10,
                                    'max' => 50,
                                ],
                            ],
                            'default' => [
                                'size' => '',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .social-item' => 'font-size: {{SIZE}}{{UNIT}};',
                            ]
                        ),
                         
                        array(
                            'name' => 'social_item_color',
                            'label' => esc_html__('Color', 'adsett' ),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .social-item' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'social_color_hover',
                            'label' => esc_html__('Color Hover', 'adsett' ),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .social-item:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'social_bg_color',
                            'label' => esc_html__('Background Color', 'adsett' ),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .social-item' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'social_bg_color_hover',
                            'label' => esc_html__('Background Color Hover', 'adsett' ),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .social-item:hover' => 'background-color: {{VALUE}};',
                            ],
                        ),
                         
                    ),
                ),
            )
        )
    ),
    adsett_get_class_widget_path()
);