<?php
$templates = adsett_get_slider_option() ;

pxl_add_custom_widget(
    array(
        'name'       => 'pxl_slider',
        'title'      => esc_html__( 'PXL Slider', 'adsett' ),
        'icon'       => 'eicon-slides',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'swiper',
            'adsett-swiper-slider',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'source_section',
                    'label' => esc_html__('Source', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'slider_source',
                            'label' => esc_html__('Select Source', 'adsett'),
                            'description'        => sprintf(esc_html__('Please create your layout before choosing. %sClick Here%s','adsett'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-slider' ) ) . '">','</a>'),
                            'type' => 'select2',
                            'multiple' => true,
                            'options' => $templates,
                            'default' => [],
                            'label_block' => true
                        ),
                        array(
                            'name'         => 'slide_effect',
                            'label'        => esc_html__('Transition', 'adsett'),
                            'type'         => 'select',
                            'options'      => [
                                'slide'     => esc_html__('Slide', 'adsett'),
                                'fade'      => esc_html__('Fade','adsett'),
                                'cube'      => esc_html__('Cube','adsett'),
                                'coverflow' => esc_html__('Coverflow','adsett'),
                                'flip'      => esc_html__('Flip','adsett'),
                                'creative'  => esc_html__('Creative','adsett'),
                                'cards'     => esc_html__('Cards','adsett'),
                            ], 
                            'default'      => 'slide', 
                        ),
                         
                    )
                ),
                array(
                    'name' => 'section_arrows_settings',
                    'label' => esc_html__('Arrows Settings', 'adsett'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'         => 'arrows',
                                'label'        => esc_html__('Show Arrows', 'adsett'),
                                'type'         => 'select',
                                'options'      => [
                                    'true'  => esc_html__('Yes', 'adsett'),
                                    'false' => esc_html__('No','adsett')
                                ], 
                                'default'      => 'true', 
                                'control_type' => 'responsive',
                                'prefix_class' => 'pxl-swiper-arrows%s-',
                            ),
                            array(
                                'name'         => 'arrows_style',
                                'label'        => esc_html__('Arrows Style', 'adsett'),
                                'type'         => 'select',
                                'options'      => [
                                    'text'  => esc_html__('Text', 'adsett'),
                                    'icon'  => esc_html__('Icon','adsett'),
                                ], 
                                'default'      => 'text', 
                            ),
                            array(
                                'name'         => 'arrows_layout',
                                'label'        => esc_html__('Arrows Layout', 'adsett'),
                                'type'         => 'select',
                                'options'      => [
                                    'square-df'  => esc_html__('Square Default', 'adsett'),
                                    'square-thums'  => esc_html__('Square Thumbnail','adsett'),
                                    'thums-title'  => esc_html__('Thumbnail & Title','adsett'),
                                    'thums-title-dark'  => esc_html__('Thumbnail & Title Dark','adsett'),
                                ], 
                                'default'      => 'square-df', 
                            ),
                            array(
                                'name'         => 'arrows_layout_color',
                                'label'        => esc_html__('Arrows Layout Color', 'adsett'),
                                'type'         => 'select',
                                'options'      => [
                                    ''  => esc_html__('Default', 'adsett'),
                                    'dark'  => esc_html__('Dark','adsett'),
                                ], 
                                'default'      => '', 
                                'condition' => ['arrows_layout' => 'thums-title']
                            ),
                            array(
                                'name' => 'divider_line_color',
                                'label' => esc_html__('Divider Line Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .layout-thums-title .thums-title-wrap:before' => 'background-color: {{VALUE}};',
                                ],
                                'condition' => ['arrows_layout' => 'thums-title']
                            ),
                            array(
                                'name'        => 'arrow_prev_text',
                                'label'       => esc_html__('Previous Text','adsett'),
                                'type'        => 'text',
                                'condition' => [
                                    'arrows_style' => 'text'
                                ]
                            ),
                            array(
                                'name'        => 'arrow_prev_icon',
                                'label'       => esc_html__('Previous Icon','adsett'),
                                'type'        => 'icons',
                                'label_block' => true,
                                'condition' => [
                                    'arrows_style' => 'icon'
                                ]
                            ),
                            array(
                                'name'        => 'arrow_next_text',
                                'label'       => esc_html__('Next Text','adsett'),
                                'type'        => 'text',
                                'condition' => [
                                    'arrows_style' => 'text'
                                ]
                            ),
                            array(
                                'name'        => 'arrow_next_icon',
                                'label'       => esc_html__('Next Icon','adsett'),
                                'type'        => 'icons',
                                'label_block' => true,
                                'condition' => [
                                    'arrows_style' => 'icon'
                                ],
                                'separator' => 'after'
                            ),
                            array(
                                'name' => 'arrow_prev_color',
                                'label' => esc_html__('Previous Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-slider-arrow-prev' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'arrow_prev_color_hover',
                                'label' => esc_html__('Previous Color Hover', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-slider-arrow-prev:hover' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'arrow_next_color',
                                'label' => esc_html__('Next Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-slider-arrow-next' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'arrow_next_color_hover',
                                'label' => esc_html__('Next Color Hover', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-slider-arrow-next:hover' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'arrow_prev_bg',
                                'label' => esc_html__('Previous Background', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-slider-arrow-prev .pxl-icon' => 'background: {{VALUE}};',
                                ],
                                'condition' => ['arrows_style' => 'icon'],
                            ),
                            array(
                                'name' => 'arrow_next_bg',
                                'label' => esc_html__('Next Background', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-slider-arrow-next .pxl-icon' => 'background: {{VALUE}};',
                                ],
                                'condition' => ['arrows_style' => 'icon'],
                            ),
                            array(
                                'name' => 'arrow_prev_margin',
                                'label' => esc_html__('Previous Margin(px)', 'adsett' ),
                                'type' => 'dimensions',
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-slider-arrow-prev' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'arrow_next_margin',
                                'label' => esc_html__('Next Margin(px)', 'adsett' ),
                                'type' => 'dimensions',
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-slider-arrow-next' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name'         => 'nav_position_wrap',
                                'label'        => esc_html__('Navigation Position For', 'adsett'),
                                'type'         => 'select',
                                'options'      => [
                                    'wrap'          => esc_html__('Wrap', 'adsett'),
                                    'separate'         => esc_html__('Separate','adsett'),
                                ], 
                                'default'      => 'wrap', 
                            ),
                        ),
                        adsett_position_option([
                            'prefix' => 'arrow_',
                            'selectors_class' => '.pxl-slider-arrow-wrap',
                            'condition' => ['nav_position_wrap' => 'wrap']
                        ]),
                        adsett_position_option([
                            'prefix' => 'arrow_prev_',
                            'selectors_class' => '.pxl-slider-arrow-prev',
                            'condition' => ['nav_position_wrap' => 'separate']
                        ]),
                        adsett_position_option([
                            'prefix' => 'arrow_next_',
                            'selectors_class' => '.pxl-slider-arrow-next',
                            'condition' => ['nav_position_wrap' => 'separate']
                        ]),
                        array(
                            array(
                                'name'         => 'arrow_direction',
                                'label'        => esc_html__('Arrow Direction', 'adsett'),
                                'type'         => 'select',
                                'options'      => [
                                    ''  => esc_html__('Default', 'adsett'),
                                    'row'  => esc_html__('Row', 'adsett'),
                                    'column'  => esc_html__('Columns','adsett'),
                                ], 
                                'default'      => '', 
                                'control_type' => 'responsive',
                                'prefix_class' => 'pxl-swiper-arrows-direction%s-',
                                'separator' => 'before',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-slider-arrow-wrap' => 'flex-direction: {{VALUE}};',
                                ],
                                'condition' => ['nav_position_wrap' => 'wrap']
                            )
                        ),
                        adsett_transform_option([
                            'prefix' => 'arrow_',
                            'selectors_class' => '.pxl-slider-arrow-wrap.wrap.pxl-transforms',
                            'condition' => ['nav_position_wrap' => 'wrap']
                        ]),
                        array(
                            array(
                                'name'         => 'arrow_container',
                                'label'        => esc_html__('Arrow in Container', 'adsett'),
                                'type'         => 'select',
                                'options'      => [
                                    ''  => esc_html__('Default', 'adsett'),
                                    'in-container'  => esc_html__('In Container', 'adsett'),
                                ], 
                                'default'      => '', 
                                'separator' => 'before',
                            )
                        ),
                        adsett_elementor_animation_opts([
                            'name'   => 'arrow',
                            'label'  => '',
                        ])
                    ),
                ),
                array(
                    'name' => 'section_dots_settings',
                    'label' => esc_html__('Dots Settings', 'adsett'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'         => 'dots',
                                'label'        => esc_html__('Show dots', 'adsett'),
                                'type'         => 'select',
                                'options'      => [
                                    'true'  => esc_html__('Yes', 'adsett'),
                                    'false' => esc_html__('No','adsett')
                                ], 
                                'default'      => 'false', 
                                'control_type' => 'responsive',
                                'prefix_class' => 'pxl-swiper-dots%s-'
                            ),
                             
                            array(
                                'name'         => 'dots_style',
                                'label'        => esc_html__('Dots Style', 'adsett'),
                                'type'         => 'select',
                                'options'      => [
                                    'bullets'  => esc_html__('Bullets', 'adsett'),
                                    'squared'  => esc_html__('Squared','adsett'),
                                    'fraction'  => esc_html__('Fraction', 'adsett'),
                                ], 
                                'default'      => 'squared', 
                            ),  
                        ),
                        adsett_position_option([
                            'prefix' => 'dots_',
                            'selectors_class' => '.pxl-slider-dots',
                        ]),
                        array(
                            array(
                                'name'         => 'dots_direction',
                                'label'        => esc_html__('Dots Direction', 'adsett'),
                                'type'         => 'select',
                                'options'      => [
                                    ''  => esc_html__('Default', 'adsett'),
                                    'row'  => esc_html__('Row', 'adsett'),
                                    'column'  => esc_html__('Columns','adsett'),
                                ], 
                                'default'      => '', 
                                'control_type' => 'responsive',
                                'prefix_class' => 'pxl-slider-dots-direction%s-',
                                'separator' => 'before',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-slider-dots' => 'flex-direction: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'dot_items_margin',
                                'label' => esc_html__('Dot Items Margin(px)', 'adsett' ),
                                'type' => 'dimensions',
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-slider-pagination-bullet' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'condition' => ['dots_style' => ['bullets', 'squared']]
                            ),
                            array(
                                'name' => 'dot_bg',
                                'label' => esc_html__('Dots Background', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-slider-dots .pxl-slider-pagination-bullet:after' => 'background-color: {{VALUE}};',
                                    '{{WRAPPER}} .pxl-slider-dots .pxl-slider-pagination-bullet:hover:before, {{WRAPPER}} .pxl-slider-dots .pxl-slider-pagination-bullet.swiper-pagination-bullet-active:before' => 'border-color: {{VALUE}};',
                                ],
                                'condition' => ['dots_style' => ['bullets', 'squared']]
                            ),
                            array(
                                'name' => 'dot_bg_hover',
                                'label' => esc_html__('Dots Background Hover', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-slider-dots .pxl-slider-pagination-bullet:hover:after' => 'background-color: {{VALUE}};',
                                    '{{WRAPPER}} .pxl-slider-dots .pxl-slider-pagination-bullet.swiper-pagination-bullet-active:after' => 'background-color: {{VALUE}};',
                                ],
                                'condition' => ['dots_style' => ['bullets', 'squared']]
                            ),
                            array(
                                'name' => 'slider_number_color',
                                'label' => esc_html__('Slider Number Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-slider-pagination-fraction' => 'color: {{VALUE}};'
                                ],
                                'condition' => ['dots_style' => 'fraction']
                            ),
                            array(
                                'name' => 'slider_number_divider_bg',
                                'label' => esc_html__('Divider Background', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-slider-pagination-fraction .divider' => 'background-color: {{VALUE}};'
                                ],
                                'condition' => ['dots_style' => 'fraction']
                            ),
                        ),
                        adsett_transform_option([
                            'prefix' => 'dots_',
                            'selectors_class' => '.pxl-slider-dots.pxl-transforms',
                        ]),
                        array(
                            array(
                                'name' => 'dots_vertical_line',
                                'label' => esc_html__('Dots Vertical Line', 'adsett' ),
                                'type'      => \Elementor\Controls_Manager::SWITCHER,
                                'control_type' => 'responsive',
                                'separator' => 'before',
                                'condition' => ['dots_direction' => 'column']
                            ),
                        ),
                        adsett_elementor_animation_opts([
                            'name'   => 'dots',
                            'label'  => '',
                        ])
                    ),
                ),
                
                array(
                    'name' => 'section_carousel_settings',
                    'label' => esc_html__('Carousel Settings', 'adsett'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array( 
                            array(
                                'name' => 'pause_on_hover',
                                'label' => esc_html__('Pause on Hover', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'autoplay',
                                'label' => esc_html__('Autoplay', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'autoplay_speed',
                                'label' => esc_html__('Autoplay Speed', 'adsett'),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => 5000,
                                'condition' => [
                                    'autoplay' => 'true'
                                ]
                            ),
                            array(
                                'name' => 'infinite',
                                'label' => esc_html__('Infinite Loop', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'speed',
                                'label' => esc_html__('Animation Speed', 'adsett'),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => 500,
                            ),
                            array(
                                'name' => 'center_mode',
                                'label' => esc_html__('Center Mode', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                                'default' => false
                            ),
                        )
                    ),
                ),
                array(
                    'name' => 'section_thumbs_settings',
                    'label' => esc_html__('Thumbs Settings', 'adsett'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' =>  array( 
                        array(
                            'name'         => 'thumbs_layout',
                            'label'        => esc_html__('Thumbs Layout', 'adsett'),
                            'type'         => 'select',
                            'options'      => [
                                'none'     => esc_html__('Disable', 'adsett'),
                                'thumbs-1'      => esc_html__('Thumbs Gallery','adsett'),
                            ], 
                            'default'      => 'none', 
                        ),
                        array(
                            'name' => 'hide_in_mobile',
                            'label' => esc_html__('Hide in mobile', 'adsett'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'condition' => ['thumbs_layout' => 'thumbs-1' ]
                        ),
                        array(
                            'name' => 'thumb_num_typography',
                            'label' => esc_html__('Number Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-sliders-thumbs .thumbs-wrap .num',
                            'condition' => ['thumbs_layout' => 'thumbs-1' ]
                        ),
                        array(
                            'name' => 'thumb_title_typography',
                            'label' => esc_html__('Title Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-sliders-thumbs .thumbs-wrap .title',
                            'condition' => ['thumbs_layout' => 'thumbs-1' ]
                        ),
                    ),
                     
                ),
            )
        )
    ),
    adsett_get_class_widget_path()
);

