<?php 
pxl_add_custom_widget(
    array(
        'name'       => 'pxl_slider_item',
        'title'      => esc_html__('PXL Slider Item', 'adsett'),
        'icon'       => 'eicon-slideshow',
        'categories' => array('pxltheme-core'),
        'params'     => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__('Layout', 'adsett' ),
                    'tab'      => 'layout',
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__('Templates', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_slide_item-1.jpg'
                                ],
                            ],
                            'prefix_class' => 'pxl-slider-item-'
                        )
                    ),
                ), 
                array(
                    'name'     => 'slide_settings',
                    'label'    => esc_html__('Slider Settings', 'adsett'),
                    'tab'      => 'settings',
                    'controls' => array(
                        array(
                            'label'        => esc_html__('Slider Height', 'adsett'), 
                            'name'         => 'slider_height',
                            'type'         => 'number',
                            'control_type' => 'responsive',
                            'selectors'    => [
                                '{{WRAPPER}} .pxl-slide-item-wrap, {{WRAPPER}} .slide-content-wrap > div' => 'height:{{VALUE}}px'
                            ],
                            'default'      => '922' 
                        ),
                        array(
                            'name'      => 'ken_burns',
                            'label'     => esc_html__( 'Ken Burns Effect', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SWITCHER,
                            'frontend_available' => true,
                        ),
                        array(
                            'name'         => 'ken_burns_direction',
                            'label'        => esc_html__('Direction', 'adsett'),
                            'type'         => 'select',
                            'default' => 'in',
                            'options' => [
                                'in' => esc_html__( 'In', 'adsett' ),
                                'out' => esc_html__( 'Out', 'adsett' ),
                            ],
                            'frontend_available' => true,
                        ),
                        array(
                            'name' => 'content_margin',
                            'label' => esc_html__('Content Margin', 'adsett' ),
                            'type' => 'dimensions',
                            'size_units' => [ 'px', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name'        => 'bg_image',
                            'label'       => esc_html__('Slide Background Image', 'adsett'),
                            'type'        => 'media',
                            'label_block' => true
                        ),
                        array(
                            'name'        => 'overlay_bg_image',
                            'label'       => esc_html__('Overlay Background Image', 'adsett'),
                            'type'        => 'media',
                            'label_block' => true
                        ),
                        array(
                            'name'        => 'bg_color',
                            'label'       => esc_html__( 'Background Overlay Color', 'adsett' ),
                            'type'        => 'color',
                            'control_type' => 'responsive',
                            'selectors'  => [
                                '{{WRAPPER}} .mask-ovl, {{WRAPPER}} .overlay-color' => 'background-color:{{VALUE}};'
                            ]
                        ),
                        array(
                            'name'      => 'overlay_bg_animation',
                            'label'     => esc_html__( 'Overlay Motion Effect', 'adsett' ),
                            'type'      => 'animation'
                        ),
                        array(
                            'name'      => 'overlay_bg_animation_delay',
                            'label'     => esc_html__( 'Overlay Transition Delay', 'adsett' ),
                            'type'      => 'text',
                        ),
                    )
                ),  
                array(
                    'name'     => 'slide_large_heading',
                    'label'    => esc_html__('Heading', 'adsett'),
                    'tab'      => 'content',
                    'controls' => array(  
                        array(
                            'name'        => 'large_heading',
                            'label'       => esc_html__('Heading','adsett'),
                            'type'        => 'textarea',
                            'placeholder' => esc_html__( 'Enter your text', 'adsett' ),
                            'label_block' => true,
                        ),
                        array(
                            'name'        => 'large_heading_color',
                            'label'       => esc_html__( 'Color', 'adsett' ),
                            'type'        => 'color',
                            'control_type' => 'responsive',
                            'selectors'  => [
                                '{{WRAPPER}} .large-heading' => 'color:{{VALUE}};'
                            ]
                        ),
                        array(
                            'name'  => 'large_heading_width',
                            'label' => esc_html__( 'Width', 'adsett' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'size_units'   => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' =>  270,
                                    'max' => 1600,
                                ],
                                '%' => [
                                    'min' =>  10,
                                    'max' =>  100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .large-heading' => 'max-width: {{SIZE}}{{UNIT}};',
                            ] 
                        ),
                        array(
                            'name'         => 'large_heading_typo',
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .large-heading'
                        ),
                        array(
                            'name'         => 'large_heading_shadow',
                            'type'         => \Elementor\Group_Control_Text_Shadow::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .large-heading'
                        ),
                        array(
                            'name' => 'large_heading_space',
                            'label' => esc_html__('Heading Margin(px)', 'adsett' ),
                            'type' => 'dimensions',
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .large-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name'      => 'large_heading_animation',
                            'label'     => esc_html__( 'Motion Effect', 'adsett' ),
                            'type'      => 'animation'
                        ),
                        array(
                            'name'      => 'large_heading_animation_delay',
                            'label'     => esc_html__( 'Transition Delay', 'adsett' ),
                            'type'      => 'text'
                        ),
                    ),
                ),   
                array(
                    'name'     => 'slide_small_heading',
                    'label'    => esc_html__('Sub Heading', 'adsett'),
                    'tab'      => 'content',
                    'controls' => array(
                        array(
                            'name'        => 'small_heading',
                            'label'       => esc_html__('Sub Heading','adsett'),
                            'type'        => 'textarea',
                            'placeholder' => esc_html__( 'Enter your text', 'adsett' ),
                            'label_block' => true,
                        ),
                        array(
                            'name'        => 'small_heading_color',
                            'label'       => esc_html__( 'Color', 'adsett' ),
                            'type'        => 'color',
                            'control_type' => 'responsive',
                            'selectors'  => [
                                '{{WRAPPER}} .small-heading' => 'color:{{VALUE}};'
                            ]
                        ), 
                        array(
                            'name'        => 'small_heading_stroke_color',
                            'label'       => esc_html__( 'Stroke Color', 'adsett' ),
                            'type'        => 'color',
                            'control_type' => 'responsive',
                            'selectors'  => [
                                '{{WRAPPER}} .small-heading' => '-webkit-text-stroke-color:{{VALUE}};'
                            ]
                        ), 
                        array(
                            'name'         => 'small_heading_typo',
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .small-heading'
                        ),
                        array(
                            'name' => 'small_heading_space',
                            'label' => esc_html__('Sub Heading Margin(px)', 'adsett' ),
                            'type' => 'dimensions',
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .small-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name'        => 'small_heading_animation',
                            'label'       => esc_html__( 'Motion Effect', 'adsett' ),
                            'type'        => 'animation',
                            'label_block' => false,
                        ),
                        array(
                            'name'      => 'small_heading_animation_delay',
                            'label'     => esc_html__( 'Transition Delay', 'adsett' ),
                            'type'      => 'text'
                        ),
                        array(
                            'name'      => 'small_heading_custom_cls',
                            'label'     => esc_html__( 'Custom Class', 'adsett' ),
                            'type'      => 'text'
                        ),
                    ),    
                ), 
                array(
                    'name'     => 'slide_desc',
                    'label'    => esc_html__('Description', 'adsett'),
                    'tab'      => 'content',
                    'controls' => array(
                        array(
                            'name'        => 'desc',
                            'label'       => esc_html__('Description','adsett'),
                            'type'        => 'textarea',
                            'placeholder' => esc_html__( 'Enter your text', 'adsett' ),
                            'label_block' => true,
                        ),
                        array(
                            'name'        => 'desc_color',
                            'label'       => esc_html__( 'Color', 'adsett' ),
                            'type'        => 'color',
                            'control_type' => 'responsive',
                            'selectors'  => [
                                '{{WRAPPER}} .desc' => 'color:{{VALUE}};'
                            ]
                        ),
                        array(
                            'name'  => 'desc_width',
                            'label' => esc_html__( 'Description Width', 'adsett' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'size_units'   => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' =>  270,
                                    'max' => 1600,
                                ],
                                '%' => [
                                    'min' =>  10,
                                    'max' =>  100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .desc' => 'max-width: {{SIZE}}{{UNIT}};',
                            ] 
                        ),
                        array(
                            'name'         => 'description_typo',
                            'type'         => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .desc'
                        ),
                        array(
                            'name' => 'desc_space',
                            'label' => esc_html__('Description Margin(px)', 'adsett' ),
                            'type' => 'dimensions',
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name'      => 'desc_animation',
                            'label'     => esc_html__( 'Motion Effect', 'adsett' ),
                            'type'      => 'animation'
                        ),
                        array(
                            'name'      => 'desc_animation_delay',
                            'label'     => esc_html__( 'Transition Delay', 'adsett' ),
                            'type'      => 'text',
                        ),
                    ),
                ), 
                array(
                    'name'     => 'slide_btn1',
                    'label'    => esc_html__('Button 1', 'adsett'),
                    'tab'      => 'content',
                    'controls' => array(
                        array(
                            'name'    => 'btn1_type',
                            'label'   => esc_html__( 'Button type', 'adsett' ),
                            'type'    => 'select',
                            'default' => 'default',
                            'options' => [
                                'default'        => esc_html__( 'Default', 'adsett' ),
                                'outline-under'  => esc_html__( 'Border outline under', 'adsett' ),
                                'outline-above'  => esc_html__( 'Border outline above', 'adsett' ),
                                'outline-around' => esc_html__( 'Border outline around', 'adsett' ),
                            ]
                        ),
                        array(
                            'name'    => 'btn1_hover_style',
                            'label'   => esc_html__( 'Border Hover Style', 'adsett' ),
                            'type'    => 'select',
                            'default' => 'transform',
                            'options' => [
                                'transform'        => esc_html__( 'Transform', 'adsett' ),
                                'draw'  => esc_html__( 'Draw', 'adsett' ),
                            ]
                        ),
                        array(
                            'name'      => 'btn1_text',
                            'label'     => esc_html__( 'Button text', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::TEXT,
                            'default'   => esc_html__('About us','adsett'),
                        ),
                        array(
                            'name' => 'btn1_link',
                            'label' => esc_html__('Button Link', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'placeholder' => esc_html__('https://your-link.com', 'adsett' ),
                            'default' => [
                                'url' => '',
                            ],
                        ),
                        array(
                            'name'             => 'btn1_icon',
                            'label'            => esc_html__( 'Button Icon', 'adsett' ),
                            'type'             => 'icons',
                            'default'          => [],
                        ),
                        array(
                            'name' => 'btn1_icon_align',
                            'label' => esc_html__('Icon Position', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'right',
                            'options' => [
                                'right' => esc_html__('After', 'adsett' ),
                                'left' => esc_html__('Before', 'adsett' ),
                            ]
                        ),
                        array(
                            'name' => 'btn1_padding',
                            'label' => esc_html__('Padding', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'btn1_margin',
                            'label' => esc_html__('Margin(px)', 'adsett' ),
                            'type' => 'dimensions',
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'btn1_typography',
                            'label' => esc_html__('Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .sl-content-inner .btn1',
                        ),
                        array(
                            'name' => 'btn1_color',
                            'label' => esc_html__('Text Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn1' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'btn1_color_hover',
                            'label' => esc_html__('Text Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn1:hover' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'btn1_bg_color',
                            'label' => esc_html__('Background Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn1' => 'background: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'btn1_bg_color_hover',
                            'label' => esc_html__('Background Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn1:hover, {{WRAPPER}} .sl-content-inner .btn1:focus' => 'background: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'btn1_border_color',
                            'label' => esc_html__('Border Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn1.pxl-btn:after' => 'border-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'btn1_border_color_hover',
                            'label' => esc_html__('Border Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn1.pxl-btn.transform:hover:after' => 'border-color: {{VALUE}} !important;',
                                '{{WRAPPER}} .sl-content-inner .btn1.pxl-btn:hover span.draw:before' => 'background-color: {{VALUE}} !important;',
                                '{{WRAPPER}} .sl-content-inner .btn1.pxl-btn:hover span.draw:after' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name'      => 'btn1_animation',
                            'label'     => esc_html__( 'Motion Effect', 'adsett' ),
                            'type'      => 'animation'
                        ),
                        array(
                            'name'      => 'btn1_animation_delay',
                            'label'     => esc_html__( 'Transition Delay', 'adsett' ),
                            'type'      => 'text',
                        ),
                    ),
                ),
                array(
                    'name'     => 'slide_btn2',
                    'label'    => esc_html__('Button 2', 'adsett'),
                    'tab'      => 'content',
                    'controls' => array(
                        array(
                            'name'    => 'btn2_type',
                            'label'   => esc_html__( 'Button type', 'adsett' ),
                            'type'    => 'select',
                            'default' => 'default',
                            'options' => [
                                'default'        => esc_html__( 'Default', 'adsett' ),
                                'outline-under'  => esc_html__( 'Border outline under', 'adsett' ),
                                'outline-above'  => esc_html__( 'Border outline above', 'adsett' ),
                                'outline-around' => esc_html__( 'Border outline around', 'adsett' ),
                            ]
                        ),
                        array(
                            'name'    => 'btn2_hover_style',
                            'label'   => esc_html__( 'Border Hover Style', 'adsett' ),
                            'type'    => 'select',
                            'default' => 'transform',
                            'options' => [
                                'transform'        => esc_html__( 'Transform', 'adsett' ),
                                'draw'  => esc_html__( 'Draw', 'adsett' ),
                            ]
                        ),
                        array(
                            'name'      => 'btn2_text',
                            'label'     => esc_html__( 'Button text', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::TEXT,
                            'default'   => esc_html__('About us','adsett'),
                        ),
                        array(
                            'name' => 'btn2_link',
                            'label' => esc_html__('Button Link', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'placeholder' => esc_html__('https://your-link.com', 'adsett' ),
                            'default' => [
                                'url' => '',
                            ],
                        ),
                        array(
                            'name'             => 'btn2_icon',
                            'label'            => esc_html__( 'Button Icon', 'adsett' ),
                            'type'             => 'icons',
                            'default'          => [],
                        ),
                        array(
                            'name' => 'btn2_icon_align',
                            'label' => esc_html__('Icon Position', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'right',
                            'options' => [
                                'right' => esc_html__('After', 'adsett' ),
                                'left' => esc_html__('Before', 'adsett' ),
                            ]
                        ),
                        array(
                            'name' => 'btn2_padding',
                            'label' => esc_html__('Padding', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'btn2_margin',
                            'label' => esc_html__('Margin(px)', 'adsett' ),
                            'type' => 'dimensions',
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'btn2_typography',
                            'label' => esc_html__('Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .sl-content-inner .btn2',
                        ),
                        array(
                            'name' => 'btn2_color',
                            'label' => esc_html__('Text Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn2' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'btn2_color_hover',
                            'label' => esc_html__('Text Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn2:hover' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'btn2_bg_color',
                            'label' => esc_html__('Background Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn2' => 'background: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'btn2_bg_color_hover',
                            'label' => esc_html__('Background Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn2:hover, {{WRAPPER}} .sl-content-inner .btn2:focus' => 'background: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'btn2_border_color',
                            'label' => esc_html__('Border Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn2.pxl-btn:after' => 'border-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'btn2_border_color_hover',
                            'label' => esc_html__('Border Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sl-content-inner .btn2.pxl-btn.transform:hover:after' => 'border-color: {{VALUE}} !important;',
                                '{{WRAPPER}} .sl-content-inner .btn2.pxl-btn:hover span.draw:before' => 'background-color: {{VALUE}} !important;',
                                '{{WRAPPER}} .sl-content-inner .btn2.pxl-btn:hover span.draw:after' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name'      => 'btn2_animation',
                            'label'     => esc_html__( 'Motion Effect', 'adsett' ),
                            'type'      => 'animation'
                        ),
                        array(
                            'name'      => 'btn2_animation_delay',
                            'label'     => esc_html__( 'Transition Delay', 'adsett' ),
                            'type'      => 'text',
                        ),
                    ),
                ),
                array(
                    'name'     => 'slide_extra_info2',
                    'label'    => esc_html__('Extra Information', 'adsett'),
                    'tab'      => 'content',
                    'controls' => array(
                        array(
                            'name'        => 'line_mark_color',
                            'label'       => esc_html__( 'Line Mark Color', 'adsett' ),
                            'type'        => 'color',
                            'control_type' => 'responsive',
                            'selectors'  => [
                                '{{WRAPPER}} .large-heading .mark-top:before' => 'background-color:{{VALUE}};',
                                '{{WRAPPER}} .large-heading .mark-top:after' => 'background-color:{{VALUE}};',
                            ]
                        ), 
                    ),
                    'condition' => ['layout' => '2']
                ), 
                array(
                    'name'     => 'dots_grid',
                    'label'    => esc_html__('Dots Grid', 'adsett'),
                    'tab'      => 'content',
                    'controls' => array(
                        array(
                            'name' => 'show_dots',
                            'label' => esc_html__('Show dots', 'adsett'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true'
                        ),
                        array(
                            'name'        => 'line_color',
                            'label'       => esc_html__( 'Line Color', 'adsett' ),
                            'type'        => 'color',
                            'control_type' => 'responsive',
                            'selectors'  => [
                                '{{WRAPPER}} .pxl-dot-animate .dot-item:before' => 'background-color:{{VALUE}};'
                            ]
                        ), 
                        array(
                            'name'        => 'dots_color',
                            'label'       => esc_html__( 'Dots Color', 'adsett' ),
                            'type'        => 'color',
                            'control_type' => 'responsive',
                            'selectors'  => [
                                '{{WRAPPER}} .pxl-dot-animate .dot-item span' => 'background-color:{{VALUE}};'
                            ]
                        ), 
                    ),
                    'condition' => ['layout' => '2']
                ),
                array(
                    'name'     => 'video_player',
                    'label'    => esc_html__('Video Player', 'adsett'),
                    'tab'      => 'content',
                    'controls' => array_merge(
                        array(
                            array(
                                'name' => 'video_link',
                                'label' => esc_html__('Video URL', 'adsett'),
                                'description' => '(https://www.youtube.com/watch?v=r2YbkyYA9Gc)',
                                'type' => 'url',
                                'default' => [
                                    'url' => '',
                                    'is_external' => 'on'
                                ]
                            ), 
                            array(
                                'name' => 'video_play_bg',
                                'label' => esc_html__('Video Button Background', 'adsett'),
                                'type' => 'color',
                                'condition' => [
                                    'video_link[url]!' => ''
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-btn' => 'background-color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'video_play_bg_hover',
                                'label' => esc_html__('Video Button Background Hover', 'adsett'),
                                'type' => 'color',
                                'condition' => [
                                    'video_link[url]!' => ''
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-btn:hover' => 'background-color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name'  => 'video_play_width',
                                'label' => esc_html__( 'Video Button Width', 'adsett' ),
                                'type'  => 'slider',
                                'control_type' => 'responsive',
                                'size_units'   => [ 'px', '%' ],
                                'range' => [
                                    'px' => [
                                        'min' =>  30,
                                        'max' => 200,
                                    ],
                                    '%' => [
                                        'min' =>  1,
                                        'max' =>  100,
                                    ],
                                ],
                                'condition' => [
                                    'video_link[url]!' => ''
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .btn-video-wrap .pxl-video-btn' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
                                ] 
                            ),
                            array(
                                'name'  => 'video_play_font_size',
                                'label' => esc_html__( 'Video Font Size', 'adsett' ),
                                'type'  => 'slider',
                                'control_type' => 'responsive',
                                'size_units'   => [ 'px' ],
                                'range' => [
                                    'px' => [
                                        'min' =>  10,
                                        'max' => 50,
                                    ],
                                ],
                                'condition' => [
                                    'video_link[url]!' => ''
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-btn' => 'font-size: {{SIZE}}{{UNIT}};',
                                ] 
                            ),
                            array(
                                'name' => 'play_icon_color',
                                'label' => esc_html__('Play Icon Color', 'adsett'),
                                'type' => 'color',
                                'condition' => [
                                    'video_link[url]!' => ''
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-btn > .pxl-icon' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'play_icon_color_hover',
                                'label' => esc_html__('Play Icon Color Hover', 'adsett'),
                                'type' => 'color',
                                'condition' => [
                                    'video_link[url]!' => ''
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-btn:hover > .pxl-icon' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name'      => 'play_icon_animation',
                                'label'     => esc_html__( 'Motion Effect', 'adsett' ),
                                'type'      => 'animation',
                                'condition' => [
                                    'video_link[url]!' => ''
                                ],
                            ),
                            array(
                                'name' => 'play_icon_animation_duration',
                                'label' => esc_html__('Animation Duration', 'adsett'),
                                'type' => 'select',
                                'default' => 'normal',
                                'options' => [
                                    'slow' => esc_html__('Slow', 'adsett'),
                                    'normal' => esc_html__('Normal', 'adsett'),
                                    'fast' => esc_html__('Fast', 'adsett'),
                                ],
                                'condition' => [
                                    'video_link[url]!' => '',
                                    'play_icon_animation!' => '',
                                ]
                            ),
                            array(
                                'name'      => 'play_icon_animation_delay',
                                'label'     => esc_html__( 'Transition Delay', 'adsett' ),
                                'type'      => 'text',
                                'condition' => [
                                    'video_link[url]!' => '',
                                    'play_icon_animation!' => '',
                                ]
                            ),
                        ),
                        adsett_position_option([
                            'prefix' => 'video_',
                            'selectors_class' => '.btn-video-wrap',
                            'condition' => ['video_link[url]!' => '']
                        ])
                    ),
                ),    
            )
        )
    ),
    adsett_get_class_widget_path()
);