<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_service_grid',
        'title' => esc_html__('PXL Service Grid', 'adsett'),
        'icon' => 'eicon-gallery-grid',
        'categories' => array('pxltheme-core'),
        'scripts'    => [
            'imagesloaded',
            'isotope',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'layout_section',
                    'label' => esc_html__('Layout', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Layout', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_service_grid-1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__( 'Layout 2', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_service_grid-2.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_list',
                    'label' => esc_html__('Content', 'adsett'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'content_list',
                            'label' => esc_html__('Service List', 'adsett'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'default' => [],
                            'controls' => array(
                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Image', 'adsett' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),
                                array(
									'name'        => 'title',
									'label'       => esc_html__('Title', 'adsett'),
									'type'        => \Elementor\Controls_Manager::TEXT,
									'label_block' => true,
                                ),
                                array(
									'name'        => 'desc',
									'label'       => esc_html__('Description', 'adsett'),
									'type'        => \Elementor\Controls_Manager::TEXTAREA,
									'label_block' => true,
                                ),
						        array(
									'name'        => 'link',
									'label'       => esc_html__('Link', 'adsett'),
									'type'        => \Elementor\Controls_Manager::URL,
									'placeholder' => esc_html__('https://your-link.com', 'adsett' ),
									'default'     => [
						                'url' => '#',
						            ]
						        )
                            ),
                            'condition' => ['layout' => '1'],
                            'title_field' => '{{{ title }}}',
                        ),
                        array(
                            'name' => 'content_list2',
                            'label' => esc_html__('Service List', 'adsett'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'default' => [],
                            'controls' => array(
                                array(
                                    'name'             => 'selected_icon',
                                    'label'            => esc_html__('Icon', 'adsett' ),
                                    'type'             => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                ),
                                array(
                                    'name'        => 'title',
                                    'label'       => esc_html__('Title', 'adsett'),
                                    'type'        => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name'        => 'desc',
                                    'label'       => esc_html__('Description', 'adsett'),
                                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                                    'label_block' => true,
                                ),
                                array(
                                    'name'        => 'link_text',
                                    'label'       => esc_html__('Link Text', 'adsett' ),
                                    'type'        => \Elementor\Controls_Manager::TEXT,
                                    'default'     => esc_html__('Read More', 'adsett'),
                                    'placeholder' => esc_html__('Click here', 'adsett'),
                                ),
                                array(
                                    'name'        => 'link',
                                    'label'       => esc_html__('Link', 'adsett'),
                                    'type'        => \Elementor\Controls_Manager::URL,
                                    'placeholder' => esc_html__('https://your-link.com', 'adsett' ),
                                    'default'     => [
                                        'url' => '#',
                                    ]
                                )
                            ),
                            'condition' => ['layout' => '2'],
                            'title_field' => '{{{ title }}}',
                        ),
                    ),
                ),
                array(
                    'name' => 'grid_section',
                    'label' => esc_html__('Grid Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array(
                            array(
                                'name' => 'show_load_more',
                                'label' => esc_html__('Show Load More', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name'    => 'load_more_text',
                                'label'   => esc_html__( 'Load More Text', 'adsett' ),
                                'type'    => 'text',
                                'condition' => [
                                    'show_load_more' => 'true',
                                ],
                            ),
                            array(
                                'name'    => 'number_item_show',
                                'label'   => esc_html__( 'Number of item to show', 'adsett' ),
                                'type'    => 'number',
                                'default' => '',
                                'condition' => [
                                    'show_load_more' => 'true',
                                ],
                            ),
                            array(
                                'name'    => 'number_loadmore_show',
                                'label'   => esc_html__( 'Number of item to show on load more', 'adsett' ),
                                'type'    => 'number',
                                'default' => '',
                                'condition' => [
                                    'show_load_more' => 'true',
                                ],
                            ),
                            array(
                                'name'         => 'load_more_gap_top',
                                'label'        => esc_html__( 'Load More Gap Top', 'adsett' ),
                                'description'  => esc_html__( 'Add extra space at top of load more button','adsett'),
                                'type'         => \Elementor\Controls_Manager::NUMBER,
                                'default'      => 0,
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-service-grid .load-more-wrap' => 'margin-top: {{VALUE}}px;',
                                ],
                                'condition' => [
                                    'show_load_more' => 'true',
                                ],
                            ),
                            array(
                                'name'         => 'load_more_gap_bottom',
                                'label'        => esc_html__( 'Load More Gap Bottom', 'adsett' ),
                                'description'  => esc_html__( 'Add extra space at bottom of load more button','adsett'),
                                'type'         => \Elementor\Controls_Manager::NUMBER,
                                'default'      => 0,
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-service-grid .load-more-wrap' => 'margin-bottom: {{VALUE}}px;',
                                ],
                                'condition' => [
                                    'show_load_more' => 'true',
                                ],
                            ),
                            array(
                                'name' => 'item_padding',
                                'label' => esc_html__('Item Padding', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'default' => [
                                    'top' => '15',
                                    'right' => '15',
                                    'bottom' => '15',
                                    'left' => '15'
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-grid-inner' => 'margin-top: -{{TOP}}{{UNIT}}; margin-right: -{{RIGHT}}{{UNIT}}; margin-bottom: -{{BOTTOM}}{{UNIT}}; margin-left: -{{LEFT}}{{UNIT}};',
                                    '{{WRAPPER}} .pxl-grid-inner .grid-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'control_type' => 'responsive',
                            ),
                            array(
                                'name'         => 'gap_extra',
                                'label'        => esc_html__( 'Item Gap Bottom', 'adsett' ),
                                'description'  => esc_html__( 'Add extra space at bottom of each items','adsett'),
                                'type'         => \Elementor\Controls_Manager::NUMBER,
                                'default'      => 0,
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-grid-inner .grid-item' => 'margin-bottom: {{VALUE}}px;',
                                ],
                            )
                        ),
                        array(
                            array(
                                'name'    => 'layout_mode',
                                'label'   => esc_html__( 'Layout Mode', 'adsett' ),
                                'type'    => \Elementor\Controls_Manager::SELECT,
                                'options' => [
                                    'fitRows' => esc_html__( 'Basic Grid', 'adsett' ),
                                    'masonry' => esc_html__( 'Masonry Grid', 'adsett' ),
                                ],
                                'default'   => 'fitRows'
                            ), 
                        ),
                        adsett_elementor_animation_opts([
                            'name'   => 'item',
                            'label' => esc_html__('Item', 'adsett'),
                        ]),
                        adsett_grid_column_settings(),
                        array(
                            array(
                                'name'        => 'img_size',
                                'label'       => esc_html__('Image Size', 'adsett' ),
                                'type'        => \Elementor\Controls_Manager::TEXT,
                                'default'     => '666x522',
                                'description' =>  esc_html__('Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).', 'adsett')
                            ),
                        ),
                        array(
                            array(
                                'name'      => 'grid_custom_columns',
                                'label'     => esc_html__('Custom Items Columns', 'adsett'),
                                'type'      => \Elementor\Controls_Manager::REPEATER,
                                'controls' => array_merge(
                                    adsett_grid_custom_column_settings(),
                                    array(
                                        array(
                                            'name'        => 'img_size_c',
                                            'label'       => esc_html__('Image Size', 'adsett' ),
                                            'type'        => \Elementor\Controls_Manager::TEXT,
                                            'description' => esc_html__('Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).', 'adsett'),
                                        ),
                                    ),
                                    adsett_elementor_animation_opts([
                                        'name'  => 'item_c',
                                        'label' => esc_html__('Item', 'adsett'),
                                    ])
                                ),
                            ),
                        )
                    ),
                ),
                array(
                    'name' => 'style_section',
                    'label' => esc_html__('Style', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'bg_color',
                            'label' => esc_html__('Background Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-grid.layout-2 .grid-item-inner' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => '2'],
                        ),
                        array(
                            'name' => 'bg_overlay_color',
                            'label' => esc_html__('Background Overlay Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-grid .grid-item-inner:hover .pxl-overlay' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'truncate_title',
                            'label' => esc_html__('Truncate Title', 'adsett'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'return_value' => 'yes',
                            'default' => 'yes',
                            'condition' => ['layout' => '1'],
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-grid .title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Title Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-service-grid .title',
                        ), 
                        array(
                            'name' => 'desc_color',
                            'label' => esc_html__('Description Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-grid .desc' => 'color: {{VALUE}};',
                            ],
                        ), 
                        array(
                            'name' => 'desc_typography',
                            'label' => esc_html__('Description Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-service-grid .desc',
                        ),
                    ),
                ),
                 
            ),
        ),
    ),
    adsett_get_class_widget_path()
);