<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_service_carousel',
        'title' => esc_html__('PXL Service Carousel', 'adsett'),
        'icon' => 'eicon-slider-push',
        'categories' => array('pxltheme-core'),
        'scripts' => [
            'swiper',
            'adsett-swiper',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'layout_section',
                    'label' => esc_html__('Layout', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Layout', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_service_carousel-1.jpg'
                                ],
                            ],
                            'prefix_class' => 'pxl-service-carousel-layout-',
                        ),
                        
                    ),
                ),
                array(
                    'name' => 'section_list',
                    'label' => esc_html__('Content', 'adsett'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'content_list',
                            'label' => esc_html__('Service List', 'adsett'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'default' => [],
                            'controls' => array(
                                array(
									'name'             => 'selected_icon',
									'label'            => esc_html__('Icon', 'adsett' ),
									'type'             => \Elementor\Controls_Manager::ICONS,
									'fa4compatibility' => 'icon',
                                ),
                                array(
									'name'        => 'title',
									'label'       => esc_html__('Title', 'adsett'),
									'type'        => \Elementor\Controls_Manager::TEXT,
									'label_block' => true,
                                ),
                                array(
									'name'        => 'desc',
									'label'       => esc_html__('Description', 'adsett'),
									'type'        => \Elementor\Controls_Manager::TEXTAREA,
									'label_block' => true,
                                ),
                                array(
						            'name'        => 'link_text',
						            'label'       => esc_html__('Link Text', 'adsett' ),
						            'type'        => \Elementor\Controls_Manager::TEXT,
						            'default'     => esc_html__('Read More', 'adsett'),
						            'placeholder' => esc_html__('Click here', 'adsett'),
						        ),
						        array(
									'name'        => 'link',
									'label'       => esc_html__('Link', 'adsett'),
									'type'        => \Elementor\Controls_Manager::URL,
									'placeholder' => esc_html__('https://your-link.com', 'adsett' ),
									'default'     => [
						                'url' => '#',
						            ]
						        )
                                
                            ),
                            'title_field' => '{{{ title }}}',
                        ),
                    ),
                ),
                array(
                    'name' => 'style_section',
                    'label' => esc_html__('Style', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'bg_color',
                            'label' => esc_html__('Background Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-1 .item-inner' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => '1']
                        ),
                        array(
                            'name' => 'bg_color_hover',
                            'label' => esc_html__('Background Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-1 .pxl-overlay' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => '1']
                        ),
                        array(
                            'name' => 'icon_color',
                            'label' => esc_html__('Icon Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-1 .item-icon' => 'color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => '1']
                        ),
                        array(
                            'name' => 'icon_color_hover',
                            'label' => esc_html__('Icon Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-1 .item-inner:hover .item-icon' => 'color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => '1']
                        ),
                        array(
                            'name' => 'num_color',
                            'label' => esc_html__('Number Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-1 .number' => 'color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => '1']
                        ),
                        array(
                            'name' => 'num_color_hover',
                            'label' => esc_html__('Number Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-1 .number-hover' => 'color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => '1']
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-1 .item-title' => 'color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => '1']
                        ),
                        array(
                            'name' => 'title_color_hover',
                            'label' => esc_html__('Title Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-1 .item-inner:hover .item-title' => 'color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => '1']
                        ),
                        array(
                            'name' => 'title_border_color',
                            'label' => esc_html__('Title Border Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-1 .item-title:before' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => '1']
                        ),   
                        array(
                            'name' => 'title_border_color_hover',
                            'label' => esc_html__('Title Border Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-1 .item-title:after' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => '1']
                        ),  
                        array(
                            'name' => 'desc_color',
                            'label' => esc_html__('Description Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-1 .desc' => 'color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => '1']
                        ), 
                        array(
                            'name' => 'btn_bg',
                            'label' => esc_html__('Button Background Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-1 .pxl-btn' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => '1']
                        ),
                        array(
                            'name' => 'btn_color',
                            'label' => esc_html__('Button Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-1 .pxl-btn' => 'color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => '1']
                        ),
                        array(
                            'name' => 'btn_border_color',
                            'label' => esc_html__('Button Border Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-1 .pxl-btn:after' => 'border-color: {{VALUE}};',
                            ],
                            'condition' => ['layout' => '1']
                        ), 
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Title Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .layout-1 .item-title',
                        ),
                        array(
                            'name' => 'desc_typography',
                            'label' => esc_html__('Description Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .layout-1 .desc',
                        ),
                    ),
                ),
                array(
                    'name' => 'carousel_setting',
                    'label' => esc_html__('Carousel Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        adsett_carousel_column_settings(),
                        array( 
                            array(
                                'name' => 'slides_to_scroll',
                                'label' => esc_html__('Slides to scroll', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => '1',
                                'options' => [
                                    '1' => '1',
                                    '2' => '2',
                                    '3' => '3',
                                    '4' => '4',
                                    '5' => '5',
                                    '6' => '6',
                                ],
                            ),
                            array(
                                'name' => 'arrows',
                                'label' => esc_html__('Show Arrows', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'arrows_on_hover',
                                'label' => esc_html__('Show Arrows on Hover', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                                'default' => 'false',
                                'condition' => [
                                    'arrows' => 'true'
                                ]
                            ),
                            array(
                                'name' => 'dots',
                                'label' => esc_html__('Show Dots', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'pause_on_hover',
                                'label' => esc_html__('Pause on Hover', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'autoplay',
                                'label' => esc_html__('Autoplay', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'autoplay_speed',
                                'label' => esc_html__('Autoplay Speed', 'adsett'),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => 5000,
                                'condition' => [
                                    'autoplay' => 'true'
                                ]
                            ),
                            array(
                                'name'         => 'gutter',
                                'label'        => esc_html__('Gutter', 'adsett' ),
                                'type'         => 'number'
                            ),
                            array(
                                'name' => 'infinite',
                                'label' => esc_html__('Infinite Loop', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'speed',
                                'label' => esc_html__('Animation Speed', 'adsett'),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => 500,
                            ),
                        ),
                        adsett_elementor_animation_opts([
                            'name'   => 'item',
                            'label' => esc_html__('Item', 'adsett'),
                        ])
                    ),
                ),
                adsett_cursor_opts()
            ),
        ),
    ),
    adsett_get_class_widget_path()
);