<?php
// Register Quick Contact Widget
pxl_add_custom_widget(
    array(
		'name'       => 'pxl_quickcontact',
		'title'      => esc_html__( 'PXL Quick Contact', 'adsett' ),
		'icon'       => 'eicon-mail',
		'categories' => array('pxltheme-core'),
		'scripts'    => [],
		'params'     => array(
            'sections' => array(
                array(
					'name'     => 'layout_section',
					'label'    => esc_html__( 'Layout', 'adsett' ),
					'tab'      => 'layout',
					'controls' => array(
                        array(
							'name'    => 'layout',
							'label'   => esc_html__( 'Templates', 'adsett' ),
							'type'    => 'layoutcontrol',
							'default' => '1',
							'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_quickcontact-1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__( 'Layout 2', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_quickcontact-2.jpg'
                                ],
                            ],
                            'prefix_class' => 'pxl-quick-contact-layout-'
                        ),
                    ),
                ),
                  
				array(
					'name'     => 'content_section',
					'label'    => esc_html__( 'Content Settings', 'adsett' ),
					'tab'      => 'content',
					'controls' => array(
                        array(
                            'name'        => 'title',
                            'label'       => esc_html__( 'Title', 'adsett' ),
                            'type'        => 'text',
                            'placeholder' => esc_html__( 'Enter the title:', 'adsett' ),
                            'default'     => 'Call us:',  
                            'label_block' => true,
                            'condition' => ['layout' => '1']
                        ),
						array(
							'name'     => 'contact_list',
							'label'    => esc_html__( 'Contact Lists', 'adsett' ),
							'type'     => 'repeater',
							'controls' => array(
                                array(
                                    'name' => 'pxl_icon',
                                    'label' => esc_html__('Icon (layout 2)', 'adsett' ),
                                    'type' => 'icons',
                                    'fa4compatibility' => 'icon',
                                    'default' => [
                                        'value' => 'pxli pxli-marker-alt',
                                        'library' => 'pxli-icon',
                                    ],
                                ), 
                                array(
                                    'name'        => 'item_content',
                                    'label'       => esc_html__( 'Item Content', 'adsett' ),
                                    'type'        => 'textarea',
                                    'placeholder' => esc_html__( 'Enter item Content', 'adsett' ),
                                    'default'     => '59 Main Street, USA',  
                                    'label_block' => true
                                ),
                            ),
                            'default' => [
                                [
									'pxl_icon' => ['value' => 'pxli pxli-phone-alt1','library' => 'pxli-icon'],
                                    'item_content' => '+012 (345) 56 998',
                                ],
                                [
                                    'pxl_icon' => ['value' => 'pxli pxli-envelope-regular','library' => 'pxli-icon'],
                                    'item_content' => 'support@gmail.com',
                                ],
                                [
                                    'pxl_icon' => ['value' => 'pxli pxli-marker-alt','library' => 'pxli-icon'],
                                    'item_content' => '59 Main Street, USA',
                                ]
                            ],
                              
                        ) 
                    )
				),
				array(
                    'name' => 'qc_style',
                    'label' => esc_html__('Style', 'adsett'),
                    'tab' => 'style',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'         => 'qc_align',
                                'label'        => esc_html__( 'Alignment', 'adsett' ),
                                'type'         => 'choose',
                                'control_type' => 'responsive',
                                'options' => [
                                    'start' => [
                                        'title' => esc_html__( 'Start', 'adsett' ),
                                        'icon' => 'eicon-text-align-left',
                                    ],
                                    'center' => [
                                        'title' => esc_html__( 'Center', 'adsett' ),
                                        'icon' => 'eicon-text-align-center',
                                    ],
                                    'end' => [
                                        'title' => esc_html__( 'End', 'adsett' ),
                                        'icon' => 'eicon-text-align-right',
                                    ]
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-qc-wrap' => 'justify-content: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'item_text_color',
                                'label' => esc_html__('Content item Color', 'adsett' ),
                                'type' => 'color',
                                'selectors' => [
                                    '{{WRAPPER}} .qc-content-wrap' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'item_link_color',
                                'label' => esc_html__('Item Link Color', 'adsett' ),
                                'type' => 'color',
                                'selectors' => [
                                    '{{WRAPPER}} .qc-content-wrap a' => 'color: {{VALUE}};',
                                ],
                            ), 
                            array(
                                'name' => 'item_link_color_hover',
                                'label' => esc_html__('Item Link Color Hover', 'adsett' ),
                                'type' => 'color',
                                'selectors' => [
                                    '{{WRAPPER}} .qc-content-wrap a:hover' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'item_icon_color',
                                'label' => esc_html__('Icon Color', 'adsett' ),
                                'type' => 'color',
                                'selectors' => [
                                    '{{WRAPPER}} .qc-content-wrap .pxl-icon' => 'color: {{VALUE}};',
                                    '{{WRAPPER}} .qc-content-wrap svg path' => 'fill: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'item_typography',
                                'label' => esc_html__('Item text Typography', 'adsett' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .qc-content-wrap',
                            ),
                            array(
                                'name' => 'icon_size',
                                'label' => esc_html__('Icon Size (px)', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::SLIDER,
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 50,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-qc-wrap .qc-item .pxl-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                                    '{{WRAPPER}} .pxl-qc-wrap .qc-item svg' => 'width: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'icon_space',
                                'label' => esc_html__('Icon Space(px)', 'adsett' ),
                                'type' => 'dimensions',
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-qc-wrap .qc-item .pxl-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'item_spacing',
                                'label' => esc_html__('Item Space (px)', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::SLIDER,
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 300,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .qc-content-wrap .qc-item + .qc-item' => 'margin-top: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                        ),
                        adsett_elementor_animation_opts([
                            'name'   => 'item',
                            'label' => esc_html__('Item', 'adsett'),
                        ])
                    ),
                ),
            )
        )
    ),
    adsett_get_class_widget_path()
);