<?php
// Register Progress Bar Widget
pxl_add_custom_widget(
    array(
        'name'       => 'pxl_progressbar',
        'title'      => esc_html__( 'PXL Progress Bar', 'adsett' ),
        'icon'       => 'eicon-skill-bar',
        'categories' => array('pxltheme-core'),
        'scripts'    => array(
            'pxl-progressbar',
            'adsett-progressbar'
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'adsett' ),
                    'tab'      => 'layout',
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Templates', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_progressbar-1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__( 'Layout 2', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_progressbar-2.jpg'
                                ],
                                '3' => [
                                    'label' => esc_html__( 'Layout 3', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_progressbar-3.jpg'
                                ],
                                '4' => [
                                    'label' => esc_html__( 'Layout 4', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_progressbar-4.jpg'
                                ]
                            ],
                            'prefix_class' => 'pxl-progressbar-layout-'
                        ),
                    )
                ),
                array(
                    'name'     => 'source_section',
                    'label'    => esc_html__( 'Source Settings', 'adsett' ),
                    'tab'      => 'content',
                    'controls' => array(
                        array(
                            'name'     => 'progressbar_list',
                            'label'    => esc_html__( 'Progress Bar Lists', 'adsett' ),
                            'type'     => 'repeater',
                            'controls' => array_merge(
                                array(
                                    array(
                                        'name'        => 'title',
                                        'label'       => esc_html__( 'Title', 'adsett' ),
                                        'type'        => 'text',
                                        'placeholder' => esc_html__( 'Enter your title', 'adsett' ),
                                        'default'     => esc_html__( 'My Skill', 'adsett' ),
                                        'label_block' => true
                                    ),
                                    array(
                                        'name'    => 'percent',
                                        'label'   => esc_html__( 'Percentage', 'adsett' ),
                                        'type'    => 'slider',
                                        'default' => [
                                            'size' => 50,
                                            'unit' => '%',
                                        ],
                                        'label_block' => true
                                    ),
                                    array(
                                        'name' => 'item_bar_color',
                                        'label' => esc_html__( 'Bar Background Color', 'adsett' ),
                                        'type' => \Elementor\Controls_Manager::COLOR,
                                        'selectors' => [
                                            '{{WRAPPER}} {{CURRENT_ITEM}} .pxl-progress-bar' => 'background-color: {{VALUE}}',
                                        ],
                                    ),
                                )
                            ),
                            'condition' => ['layout' => ['1','2','3']],
                            'title_field' => '{{title}}'
                        ),
                        array(
                            'name' => 'circle_size',
                            'label'     => esc_html__( 'Size', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'range'     => array(
                                'px' => array(
                                    'min'  => 50,
                                    'max'  => 500,
                                    'step' => 1,
                                ),
                            ),
                            'default'   => array(
                                'size' => 200,
                            ),
                            'selectors' => array(
                                '{{WRAPPER}} .pxl-progressbar-inner' => 'width: {{SIZE}}px; height: {{SIZE}}px',
                            ),
                            'condition' => ['layout' => '4']
                        ),
                        array(
                            'name'    => 'circle_percent',
                            'label'   => esc_html__( 'Percentage', 'adsett' ),
                            'type'    => 'slider',
                            'default' => [
                                'size' => 50,
                                'unit' => '%',
                            ],
                            'label_block' => true,
                            'condition' => ['layout' => '4']
                        ),
                        array(
                            'name' => 'circle_speed',
                            'label' => esc_html__('Speed (milliseconds)', 'adsett'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'condition' => ['layout' => '4']
                        ),
                        array(
                            'name'        => 'circle_title',
                            'label'       => esc_html__( 'Title', 'adsett' ),
                            'type'        => 'text',
                            'placeholder' => esc_html__( 'Enter your title', 'adsett' ),
                            'default'     => esc_html__( 'Page Speed', 'adsett' ),
                            'label_block' => true,
                            'condition' => ['layout' => '4']
                        ),
                        array(
                            'name' => 'circle_number',
                            'label' => esc_html__('Number Value', 'adsett'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 50,
                            'condition' => ['layout' => '4']
                        ),
                        array(
                            'name' => 'prefix',
                            'label' => esc_html__('Number Prefix', 'adsett'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '',
                            'condition' => ['layout' => '4']
                        ),
                        array(
                            'name' => 'suffix',
                            'label' => esc_html__('Number Suffix', 'adsett'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '',
                            'condition' => ['layout' => '4']
                        ),
                        
                    )
                ),
                array(
                    'name' => 'section_title',
                    'label' => esc_html__( 'Style', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array_merge(
                        array(
                            array(
                                'name' => 'title_color',
                                'label' => esc_html__( 'Title Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-progressbar .progress-title' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'typography',
                                'label' => esc_html__( 'Title Typography', 'adsett' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .pxl-progressbar .progress-title',
                            ),
                            array(
                                'name' => 'percent_color',
                                'label' => esc_html__( 'Percentage Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-progressbar .progress-percentage' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'percentage_typography',
                                'label' => esc_html__( 'Percentage Typography', 'adsett' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .pxl-progressbar .progress-percentage',
                            ),
                            array(
                                'name' => 'bound_color',
                                'label' => esc_html__( 'Bound Background Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-progressbar .progress-bound' => 'background-color: {{VALUE}};',
                                    '{{WRAPPER}} .pxl-progressbar-circle-base' => 'border-color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'bar_color',
                                'label' => esc_html__( 'Bar Background Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-progressbar .pxl-progress-bar' => 'background-color: {{VALUE}};',
                                    '{{WRAPPER}} .pxl-progressbar-circle div' => 'border-color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'space_bottom',
                                'label' => esc_html__('Item Bottom Space (px)', 'adsett' ),
                                'type' => 'slider',
                                'description' => esc_html__('Enter number.', 'adsett' ),
                                'size_units' => [ 'px' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                    ],
                                ],
                                'default'    => [
                                    'unit' => 'px'
                                ],
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-progressbar .progress-item + .progress-item' => 'margin-top: {{SIZE}}{{UNIT}};',
                                ],
                                'condition' => ['layout' => ['1','2','3']],
                            ),
                        ),
                        adsett_elementor_animation_opts([
                            'name'   => 'item',
                            'label' => esc_html__('Item', 'adsett'),
                            'condition' => ['layout' => ['1','2','3']],
                        ])
                    ),
                ),
                
            )
        )
    ),
    adsett_get_class_widget_path()
);