<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_pricing_single',
        'title' => esc_html__('PXL Pricing', 'adsett'),
        'icon' => 'eicon-price-table',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'layout_section',
                    'label' => esc_html__('Layout', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Layout', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_pricing_single-1.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_list',
                    'label' => esc_html__('Content', 'adsett'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'title',
                            'label' => esc_html__('Title', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'placeholder' => esc_html__('Enter your title', 'adsett' ),
                            'label_block' => true,
                        ),
                        array(
                            'name'        => 'price_prefix',
                            'label'       => esc_html__('Price Prefix', 'adsett'),
                            'type'        => \Elementor\Controls_Manager::TEXT,
                        ),
                        array(
                            'name'        => 'price_currency',
                            'label'       => esc_html__('Currency', 'adsett'),
                            'type'        => \Elementor\Controls_Manager::TEXT,
                        ),
                        array(
                            'name'        => 'price_value',
                            'label'       => esc_html__('Price', 'adsett'),
                            'type'        => \Elementor\Controls_Manager::TEXT,
                        ),
                         
                        array(
                            'name' => 'content_list',
                            'label' => esc_html__('Feature', 'adsett'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'content',
                                    'label' => esc_html__('Content', 'adsett'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'active',
                                    'label' => esc_html__('Active', 'adsett' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'options' => [
                                        'no' => 'No',
                                        'yes' => 'Yes',
                                    ],
                                    'default' => 'yes',
                                ),
                            ),
                            'title_field' => '{{{ content }}}',
                        ),

                        array(
                            'name' => 'button_link',
                            'label' => esc_html__('Button Link', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::URL,
                        ),
                        array(
                            'name' => 'button_text',
                            'label' => esc_html__('Button Text', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '',
                            'label_block' => true,
                        ),
                    ),
                ),
                array(
                    'name' => 'style_section',
                    'label' => esc_html__('Style Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array( 
                        array(
                            'name' => 'text_align',
                            'label' => esc_html__('Alignment', 'adsett' ),
                            'type' => 'choose',
                            'control_type' => 'responsive',
                            'options' => [
                                'start' => [
                                    'title' => esc_html__( 'Start', 'adsett' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'adsett' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'end' => [
                                    'title' => esc_html__( 'End', 'adsett' ),
                                    'icon' => 'eicon-text-align-right',
                                ]
                            ],
                            'prefix_class' => 'elementor-align-',
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-pricing-single' => 'text-align: {{VALUE}};',
                                '{{WRAPPER}} .pxl-pricing-single .pricing-feature li' => 'justify-content: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'pricing_bg',
                            'label' => esc_html__('Background Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-pricing-single' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-pricing-single .pricing-title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'price_color',
                            'label' => esc_html__('Price Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-pricing-single .pricing-price' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-pricing-single.highlight-active .pricing-price span' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Title Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-pricing-single .pricing-title',
                        ),
                        array(
                            'name' => 'feature_color',
                            'label' => esc_html__('Feature Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-pricing-single .pricing-feature li, {{WRAPPER}} .pxl-pricing-single.highlight-active .pricing-feature li' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'feature_icon_color',
                            'label' => esc_html__('Feature Icon Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-pricing-single .pricing-feature li .pxl-icon' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'closed_feature_color',
                            'label' => esc_html__('Closed Feature Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-pricing-single .pricing-feature li.no-active' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'closed_feature_icon_color',
                            'label' => esc_html__('Closed Feature Icon Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-pricing-single .pricing-feature li.no-active .pxl-icon' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'feature_typography',
                            'label' => esc_html__('Feature Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-pricing-single .pricing-feature',
                        ),
                        array(
                            'name' => 'button_color',
                            'label' => esc_html__('Button Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-pricing-single .pricing-button .btn' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_color_hover',
                            'label' => esc_html__('Button Hover Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-pricing-single .pricing-button .btn:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_bg',
                            'label' => esc_html__('Button Background', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-pricing-single .pricing-button .btn' => 'background-color: {{VALUE}}; border-color: {{VALUE}}',
                            ],
                        ),
                        array(
                            'name' => 'button_bg_hover',
                            'label' => esc_html__('Button Hover Background', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-pricing-single .pricing-button .btn:hover' => 'background-color: {{VALUE}}; border-color: {{VALUE}}',
                            ],
                        ),
                        array(
                            'name' => 'item_highlight',
                            'label' => esc_html__('Highlight', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'highlight-none' => 'No',
                                'highlight-active' => 'Yes',
                            ],
                            'default' => 'highlight-none',
                        ),
                        array(
                            'name' => 'item_highlight_bg',
                            'label' => esc_html__('Hightlight Background Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-pricing-single.highlight-active' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => ['item_highlight' => 'highlight-active']
                        ), 
                    ),
                ),
            ),
        ),
    ),
    adsett_get_class_widget_path()
);