<?php
$pt_supports = ['post','portfolio'];
use Elementor\Controls_Manager;
pxl_add_custom_widget(
    array(
        'name'       => 'pxl_post_grid',
        'title'      => esc_html__('PXL Post Grid', 'adsett' ),
        'icon'       => 'eicon-posts-grid',
        'categories' => array('pxltheme-core'),
        'scripts'    => [
            'imagesloaded',
            'isotope',
            'adsett-post-grid',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'adsett' ),
                    'tab'      => 'layout',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'post_type',
                                'label'    => esc_html__( 'Select Post Type', 'adsett' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => adsett_get_post_type_options($pt_supports),
                                'default'  => 'post'
                            ) 
                        ),
                        
                        adsett_get_post_grid_layout($pt_supports)
                    ),
                ),
                 
                array(
                    'name' => 'source_section',
                    'label' => esc_html__('Source', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'select_post_by',
                                'label'    => esc_html__( 'Select posts by', 'adsett' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => [
                                    'term_selected' => esc_html__( 'Terms selected', 'adsett' ),
                                    'post_selected' => esc_html__( 'Posts selected ', 'adsett' ),
                                ],
                                'default'  => 'term_selected'
                            ) 
                        ),
                        adsett_get_grid_term_by_posttype($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        adsett_get_grid_ids_by_posttype($pt_supports, ['custom_condition' => ['select_post_by' => 'post_selected']]),
                        adsett_get_grid_ids_unselected_by_posttype($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        array(
                            array(
                                'name'    => 'orderby',
                                'label'   => esc_html__('Order By', 'adsett' ),
                                'type'    => \Elementor\Controls_Manager::SELECT,
                                'default' => 'date',
                                'options' => [
                                    'date'   => esc_html__('Date', 'adsett' ),
                                    'ID'     => esc_html__('ID', 'adsett' ),
                                    'author' => esc_html__('Author', 'adsett' ),
                                    'title'  => esc_html__('Title', 'adsett' ),
                                    'rand'   => esc_html__('Random', 'adsett' ),
                                ],
                            ),
                            array(
                                'name'    => 'order',
                                'label'   => esc_html__('Sort Order', 'adsett' ),
                                'type'    => \Elementor\Controls_Manager::SELECT,
                                'default' => 'desc',
                                'options' => [
                                    'desc' => esc_html__('Descending', 'adsett' ),
                                    'asc'  => esc_html__('Ascending', 'adsett' ),
                                ],
                            ),
                            array(
                                'name'    => 'limit',
                                'label'   => esc_html__('Total items', 'adsett' ),
                                'type'    => \Elementor\Controls_Manager::NUMBER,
                                'default' => '8',
                                'condition' => [
                                    'select_post_by' => 'term_selected',
                                ],
                            ),
                        )
                    ),
                ),
                array(
                    'name' => 'general_section',
                    'label' => esc_html__('General Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'        => 'img_size',
                                'label'       => esc_html__('Image Size', 'adsett' ),
                                'type'        => \Elementor\Controls_Manager::TEXT,
                                'description' =>  esc_html__('Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).', 'adsett')
                            ),
                            array(
                                'name'    => 'layout_mode',
                                'label'   => esc_html__( 'Layout Mode', 'adsett' ),
                                'type'    => \Elementor\Controls_Manager::SELECT,
                                'options' => [
                                    'fitRows' => esc_html__( 'Basic Grid', 'adsett' ),
                                    'masonry' => esc_html__( 'Masonry Grid', 'adsett' ),
                                ],
                                'default'   => 'fitRows'
                            ),
                            array(
                                'name'    => 'filter',
                                'label'   => esc_html__('Term Filter', 'adsett' ),
                                'type'    => \Elementor\Controls_Manager::SELECT,
                                'default' => 'false',
                                'options' => [
                                    'true'  => esc_html__('Enable', 'adsett' ),
                                    'false' => esc_html__('Disable', 'adsett' ),
                                ],
                                'condition' => [
                                    'select_post_by' => 'term_selected',
                                ],
                                
                            ),
                            array(
                                'name'      => 'filter_default_title',
                                'label'     => esc_html__('Filter Default Title', 'adsett' ),
                                'type'      => \Elementor\Controls_Manager::TEXT,
                                'default'   => esc_html__('All', 'adsett' ),
                                'condition' => [
                                    'select_post_by' => 'term_selected',
                                    'filter'         => 'true',
                                ],
                            ),
                            array(
                                'name'         => 'filter_alignment',
                                'label'        => esc_html__( 'Filter Alignment', 'adsett' ),
                                'type'         => 'choose',
                                'control_type' => 'responsive',
                                'options' => [
                                    'start' => [
                                        'title' => esc_html__( 'Start', 'adsett' ),
                                        'icon'  => 'eicon-text-align-left',
                                    ],
                                    'center' => [
                                        'title' => esc_html__( 'Center', 'adsett' ),
                                        'icon'  => 'eicon-text-align-center',
                                    ],
                                    'end' => [
                                        'title' => esc_html__( 'End', 'adsett' ),
                                        'icon'  => 'eicon-text-align-right',
                                    ]
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .grid-filter-wrap' => 'justify-content: {{VALUE}};'
                                ],
                                'default'      => 'center',
                                'condition' => [
                                    'select_post_by' => 'term_selected',
                                    'filter'         => 'true',
                                ],
                            ),
                            array(
                                'name'    => 'pagination_type',
                                'label'   => esc_html__('Pagination Type', 'adsett' ),
                                'type'    => \Elementor\Controls_Manager::SELECT,
                                'default' => 'false',
                                'options' => [
                                    'pagination' => esc_html__('Pagination', 'adsett' ),
                                    'loadmore'   => esc_html__('Loadmore', 'adsett' ),
                                    'false'      => esc_html__('Disable', 'adsett' ),
                                ],
                            ),
                            array(
                                'name'      => 'loadmore_text',
                                'label'     => esc_html__( 'Load More text', 'adsett' ),
                                'type'      => \Elementor\Controls_Manager::TEXT,
                                'default'   => esc_html__('Load More','adsett'),
                                'condition' => [
                                    'pagination_type' => 'loadmore'
                                ]
                            ),
                            array(
                                'name'             => 'loadmore_icon',
                                'label'            => esc_html__( 'Loadmore Icon', 'adsett' ),
                                'type'             => 'icons',
                                'default'          => [],
                                'condition' => [
                                    'pagination_type' => 'loadmore'
                                ]
                            ),
                            array(
                                'name' => 'icon_align',
                                'label' => esc_html__('Icon Position', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'right',
                                'options' => [
                                    'right' => esc_html__('After', 'adsett' ),
                                    'left' => esc_html__('Before', 'adsett' ),
                                ],
                                'condition' => [
                                    'pagination_type' => 'loadmore'
                                ]
                            ),
                            array(
                                'name'         => 'pagination_alignment',
                                'label'        => esc_html__( 'Pagination Alignment', 'adsett' ),
                                'type'         => 'choose',
                                'control_type' => 'responsive',
                                'options' => [
                                    'start' => [
                                        'title' => esc_html__( 'Start', 'adsett' ),
                                        'icon'  => 'eicon-text-align-left',
                                    ],
                                    'center' => [
                                        'title' => esc_html__( 'Center', 'adsett' ),
                                        'icon'  => 'eicon-text-align-center',
                                    ],
                                    'end' => [
                                        'title' => esc_html__( 'End', 'adsett' ),
                                        'icon'  => 'eicon-text-align-right',
                                    ]
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-grid-pagination, {{WRAPPER}} .pxl-load-more' => 'justify-content: {{VALUE}};'
                                ],
                                'default'      => 'center',
                                'condition' => [
                                    'pagination_type' => ['pagination', 'loadmore'],
                                ],
                            ),
                            array(
                                'name' => 'item_padding',
                                'label' => esc_html__('Item Padding', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'default' => [
                                    'top' => '15',
                                    'right' => '15',
                                    'bottom' => '15',
                                    'left' => '15'
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-grid-inner' => 'margin-top: -{{TOP}}{{UNIT}}; margin-right: -{{RIGHT}}{{UNIT}}; margin-bottom: -{{BOTTOM}}{{UNIT}}; margin-left: -{{LEFT}}{{UNIT}};',
                                    '{{WRAPPER}} .pxl-grid-inner .grid-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'control_type' => 'responsive',
                            ),
         
                            array(
                                'name'         => 'gap_extra',
                                'label'        => esc_html__( 'Item Gap Bottom', 'adsett' ),
                                'description'  => esc_html__( 'Add extra space at bottom of each items','adsett'),
                                'type'         => \Elementor\Controls_Manager::NUMBER,
                                'default'      => 0,
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-grid-inner .grid-item' => 'margin-bottom: {{VALUE}}px;',
                                ],
                            )
                        ),
                        adsett_elementor_animation_opts([
                            'name'   => 'item',
                            'label' => esc_html__('Item', 'adsett'),
                        ])
                    )
                ),
                array(
                    'name' => 'grid_section',
                    'label' => esc_html__('Grid Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array_merge(
                        adsett_grid_column_settings(),
                        array(
                            array(
                                'name'      => 'grid_custom_columns',
                                'label'     => esc_html__('Custom Items Columns', 'adsett'),
                                'type'      => \Elementor\Controls_Manager::REPEATER,
                                'condition' => [
                                    'layout_mode' => ['masonry'],
                                ],
                                'controls' => array_merge(
                                    adsett_grid_custom_column_settings(),
                                    array(
                                        array(
                                            'name'        => 'img_size_c',
                                            'label'       => esc_html__('Image Size', 'adsett' ),
                                            'type'        => \Elementor\Controls_Manager::TEXT,
                                            'description' => esc_html__('Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).', 'adsett'),
                                        ),
                                    ),
                                    adsett_elementor_animation_opts([
                                        'name'  => 'item_c',
                                        'label' => esc_html__('Item', 'adsett'),
                                    ])
                                ),
                            ),
                        )
                        
                    ),
                ),
                array(
                    'name' => 'display_section',
                    'label' => esc_html__('Display Options', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name'      => 'show_author',
                            'label'     => esc_html__('Show Author', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SWITCHER,
                            'default'   => 'false',
                            'condition' => ['post_type' => 'post']
                        ),
                        array(
                            'name'      => 'show_date',
                            'label'     => esc_html__('Show Date', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SWITCHER,
                            'default'   => 'true',
                            'condition' => ['post_type' => 'post']
                        ),
                        array(
                            'name'      => 'show_category',
                            'label'     => esc_html__('Show Category', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SWITCHER,
                            'default'   => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1','portfolio-2']]
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        
                        array(
                            'name'      => 'show_excerpt',
                            'label'     => esc_html__('Show Excerpt', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SWITCHER,
                            'default'   => 'true',
                            'condition' => ['post_type' => 'post']
                        ),
                        array(
                            'name'      => 'num_words',
                            'label'     => esc_html__('Number of Words', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::NUMBER,
                            'default'   => 25,
                            'condition' => [
                                'post_type'    => 'post',
                                'show_excerpt' => 'true',
                            ],
                        ),
                        
                        array(
                            'name'      => 'show_button',
                            'label'     => esc_html__('Show Button Readmore', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SWITCHER,
                            'default'   => 'true',
                            'condition' => ['post_type' => 'post']
                        ),
                        array(
                            'name'      => 'button_text',
                            'label'     => esc_html__('Button Text', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'post_type'    => 'post',
                                'show_button' => 'true',
                                'layout_post' => ['post-1','post-3']
                            ],
                        ),
                        
                    ),
                ),
                array(
                    'name' => 'style_section',
                    'label' => esc_html__('Style Options', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'content_typography',
                            'label' => esc_html__('Content Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-post-grid .item-content',
                        ),
                        array(
                            'name' => 'meta_color',
                            'label' => esc_html__('Meta Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-grid .item-post-meta' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-post-grid .item-post-meta .meta-inner > * + *:before' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1','post-2']
                            ]
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-grid .item-title' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1','post-2']
                            ]
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Title Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-post-grid .item-title, {{WRAPPER}} .pxl-post-grid .item-post-meta .number',
                        ),
                        array(
                            'name' => 'excerpt_color',
                            'label' => esc_html__('Excerpt Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-grid .item-excerpt' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-2']
                            ]
                        ),
                        array(
                            'name' => 'img_bg_hover',
                            'label' => esc_html__('Background hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-grid .item-featured .pxl-overlay' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1']
                            ]
                        ),
                        array(
                            'name' => 'img_bg_overlay',
                            'label' => esc_html__('Background Overlay', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-grid .item-featured:before' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-2']
                            ]
                        ),
                        array(
                            'name' => 'content_bg_hover',
                            'label' => esc_html__('Background hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-grid .item-content-hover' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1']
                            ]
                        ),
                        array(
                            'name' => 'meta_hover_color',
                            'label' => esc_html__('Meta Hover Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-grid .item-content-hover .item-post-meta' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-post-grid .item-content-hover .item-post-meta .meta-inner > * + *:before' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1']
                            ]
                        ),
                        array(
                            'name' => 'excerpt_hover_color',
                            'label' => esc_html__('Excerpt Hover Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-grid .item-content-hover .item-excerpt' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1']
                            ]
                        ),
                        array(
                            'name' => 'css_filters',
                            'label' => esc_html__('CSS Filters', 'adsett' ),
                            'type' => \Elementor\Group_Control_Css_Filter::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-post-grid .item-featured img',
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1']
                            ]
                        ),
                        array(
                            'name' => 'truncate_title',
                            'label' => esc_html__('Truncate Title', 'adsett'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'return_value' => 'yes',
                            'default' => 'yes',
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-3']
                            ],
                        ),
                    ),
                ),
            ),
        ),
    ),
    adsett_get_class_widget_path()
);