<?php
$pt_supports = ['post','portfolio'];
pxl_add_custom_widget(
    array(
        'name' => 'pxl_post_carousel',
        'title' => esc_html__('PXL Post Carousel', 'adsett' ),
        'icon' => 'eicon-posts-carousel',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'swiper',
            'adsett-swiper',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'adsett' ),
                    'tab'      => 'layout',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'post_type',
                                'label'    => esc_html__( 'Select Post Type', 'adsett' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => adsett_get_post_type_options($pt_supports),
                                'default'  => 'post'
                            ) 
                        ),
                        adsett_get_post_carousel_layout($pt_supports)
                    ),
                ),
                array(
                    'name' => 'source_section',
                    'label' => esc_html__('Source', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'select_post_by',
                                'label'    => esc_html__( 'Select posts by', 'adsett' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => [
                                    'term_selected' => esc_html__( 'Terms selected', 'adsett' ),
                                    'post_selected' => esc_html__( 'Posts selected ', 'adsett' ),
                                ],
                                'default'  => 'term_selected'
                            ) 
                        ),
                        adsett_get_carousel_term_by_posttype($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        adsett_get_carousel_ids_by_posttype($pt_supports, ['custom_condition' => ['select_post_by' => 'post_selected']]),
                        adsett_get_carousel_ids_unselected_by_posttype($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        array(
                            array(
                                'name' => 'orderby',
                                'label' => esc_html__('Order By', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'date',
                                'options' => [
                                    'date' => esc_html__('Date', 'adsett' ),
                                    'ID' => esc_html__('ID', 'adsett' ),
                                    'author' => esc_html__('Author', 'adsett' ),
                                    'title' => esc_html__('Title', 'adsett' ),
                                    'rand' => esc_html__('Random', 'adsett' ),
                                ],
                            ),
                            array(
                                'name' => 'order',
                                'label' => esc_html__('Sort Order', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'desc',
                                'options' => [
                                    'desc' => esc_html__('Descending', 'adsett' ),
                                    'asc' => esc_html__('Ascending', 'adsett' ),
                                ],
                            ),
                            array(
                                'name' => 'limit',
                                'label' => esc_html__('Total items', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => '6',
                            ),
                        )
                    ),
                ),
                array(
                    'name' => 'general_section',
                    'label' => esc_html__('General Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'        => 'img_size',
                                'label'       => esc_html__('Image Size', 'adsett' ),
                                'type'        => \Elementor\Controls_Manager::TEXT,
                                'description' =>  esc_html__('Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).', 'adsett')
                            ),
                            array(
                                'name'    => 'filter',
                                'label'   => esc_html__('Term Filter', 'adsett' ),
                                'type'    => \Elementor\Controls_Manager::SELECT,
                                'default' => 'false',
                                'options' => [
                                    'true'  => esc_html__('Enable', 'adsett' ),
                                    'false' => esc_html__('Disable', 'adsett' ),
                                ],
                                'condition' => [
                                    'select_post_by' => 'term_selected',
                                ],
                            ),
                            array(
                                'name' => 'filter_icon',
                                'label' => esc_html__('Show Filter Icon', 'adsett' ),
                                'type' => 'select',
                                'options' => [
                                    'inline-block' => esc_html__('Show', 'adsett'),
                                    'none' => esc_html__('Hide', 'adsett'),
                                ],
                                'default' => 'inline-block',
                                'control_type' => 'responsive',
                                'condition' => [
                                    'select_post_by' => 'term_selected',
                                    'filter'         => 'true',
                                ],
                                'selectors'    => [
                                    '{{WRAPPER}} .pxl-portfolio-carousel .swiper-filter-wrap .filter-item .pxl-icon' => 'display: {{VALUE}}!important;',
                                ] 
                            ), 
                            array(
                                'name'      => 'filter_default_title',
                                'label'     => esc_html__('Filter Default Title', 'adsett' ),
                                'type'      => \Elementor\Controls_Manager::TEXT,
                                'default'   => esc_html__('All', 'adsett' ),
                                'condition' => [
                                    'select_post_by' => 'term_selected',
                                    'filter'         => 'true',
                                ],
                            ),
                           
                            array(
                                'name' => 'loadmore_link',
                                'label' => esc_html__('Loadmore Link', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::URL,
                                'placeholder' => esc_html__('https://your-link.com', 'adsett' ),
                                'default' => [
                                    'url' => '',
                                ],
                                'condition' => [
                                    'post_type' => 'portfolio',
                                    'layout_portfolio' => ['portfolio-1','portfolio-2']
                                ]
                            ),
                            array(
                                'name'      => 'loadmore_text',
                                'label'     => esc_html__( 'Load More text', 'adsett' ),
                                'type'      => \Elementor\Controls_Manager::TEXT,
                                'default'   => esc_html__('Load More','adsett'),
                                'condition' => [
                                    'post_type' => 'portfolio',
                                    'loadmore_link[url]!' => ''
                                ]
                            ),
                        ),
                        adsett_elementor_animation_opts([
                            'name'   => 'item',
                            'label' => esc_html__('Item Content', 'adsett'),
                        ])
                    )
                ),
                array(
                    'name' => 'carousel_setting',
                    'label' => esc_html__('Carousel Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        adsett_carousel_column_settings(),
                        array( 
                            array(
                                'name' => 'slides_to_scroll',
                                'label' => esc_html__('Slides to scroll', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => '1',
                                'options' => [
                                    '1' => '1',
                                    '2' => '2',
                                    '3' => '3',
                                    '4' => '4',
                                    '5' => '5',
                                    '6' => '6',
                                ],
                            ),
                            array(
                                'name' => 'arrows',
                                'label' => esc_html__('Show Arrows', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'arrows_position',
                                'label' => esc_html__('Arrow Position', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'nav-out-vertical',
                                'options' => [
                                    'df-layout' => esc_html__( 'Default as Layout', 'adsett' ),
                                    'nav-in-vertical' => esc_html__( 'In Vertical', 'adsett' ),
                                    'nav-out-vertical' => esc_html__( 'Out Vertical', 'adsett' ),
                                ],
                            ),
                            array(
                                'name' => 'arrows_on_hover',
                                'label' => esc_html__('Show Arrows on Hover', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                                'default' => 'false',
                            ),
                            array(
                                'name' => 'arrows_color',
                                'label' => esc_html__('Arrows Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-portfolio-carousel.layout-portfolio-3 .pxl-swiper-arrows.df-layout .pxl-swiper-arrow' => 'color: {{VALUE}};',
                                ],
                                'condition' => [
                                    'post_type'    => 'portfolio',
                                    'layout_portfolio' => ['portfolio-3']
                                ]
                            ),
                            array(
                                'name' => 'arrows_color_hover',
                                'label' => esc_html__('Arrows Color Hover', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-portfolio-carousel.layout-portfolio-3 .pxl-swiper-arrows.df-layout .pxl-swiper-arrow:hover' => 'color: {{VALUE}};',
                                ],
                                'condition' => [
                                    'post_type'    => 'portfolio',
                                    'layout_portfolio' => ['portfolio-3']
                                ]
                            ),
                            array(
                                'name' => 'dots',
                                'label' => esc_html__('Show Dots', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'pause_on_hover',
                                'label' => esc_html__('Pause on Hover', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'autoplay',
                                'label' => esc_html__('Autoplay', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'autoplay_speed',
                                'label' => esc_html__('Autoplay Speed', 'adsett'),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => 5000,
                                'condition' => [
                                    'autoplay' => 'true'
                                ]
                            ),
                            array(
                                'name'         => 'gutter',
                                'label'        => esc_html__('Gutter', 'adsett' ),
                                'type'         => 'number'
                            ),
                            array(
                                'name' => 'center_slide',
                                'label' => esc_html__('Center Slider', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                                'default' => false
                            ),
                            array(
                                'name' => 'infinite',
                                'label' => esc_html__('Infinite Loop', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'speed',
                                'label' => esc_html__('Animation Speed', 'adsett'),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => 500,
                            ),
                        )
                    ),
                ),
                array(
                    'name' => 'display_section',
                    'label' => esc_html__('Display Items Options', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'show_author',
                            'label' => esc_html__('Show Author', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                            'condition' => ['post_type' => 'post']
                        ),
                        array(
                            'name' => 'show_date',
                            'label' => esc_html__('Show Date', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'condition' => ['post_type' => 'post']
                        ),
                        array(
                            'name'      => 'show_category',
                            'label'     => esc_html__('Show Category', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SWITCHER,
                            'default'   => 'false',
                            'condition' => ['post_type' => ['post','portfolio']]
                        ),
                        array(
                            'name' => 'show_excerpt',
                            'label' => esc_html__('Show Excerpt', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'condition' => ['post_type' => 'post']
                        ),
                        array(
                            'name' => 'num_words',
                            'label' => esc_html__('Number of Words', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 25,
                            'condition' => [
                                'show_excerpt' => 'true',
                            ],
                        ),
                        
                        array(
                            'name'      => 'show_button',
                            'label'     => esc_html__('Show Button Readmore', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SWITCHER,
                            'default'   => 'true',
                            'condition' => [
                                'post_type'    => 'post'
                            ],
                        ),
                        array(
                            'name'      => 'button_text',
                            'label'     => esc_html__('Button Text', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'post_type'    => 'post',
                                'show_button'      => 'true'
                            ],
                        ),
                        array(
                            'name'      => 'show_video',
                            'label'     => esc_html__('Show Video Icon', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SWITCHER,
                            'condition' => [
                                'post_type'    => 'portfolio',
                                'layout_portfolio' => ['portfolio-3'],
                            ],
                        ),
                        array(
                            'name'      => 'show_lightbox',
                            'label'     => esc_html__('Show Lightbox Icon', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SWITCHER,
                            'condition' => [
                                'post_type'    => 'portfolio',
                                'layout_portfolio' => ['portfolio-3'],
                            ],
                        ),
                        array(
                            'name'      => 'show_link',
                            'label'     => esc_html__('Show Link', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SWITCHER,
                            'default'   => 'true',
                            'condition' => [
                                'post_type'    => 'portfolio',
                            ],
                        ),

                        array(
                            'name'      => 'link_text',
                            'label'     => esc_html__('Link Text', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'post_type'    => 'portfolio',
                                'layout_portfolio' => ['portfolio-1','portfolio-2'],
                                'show_link'      => 'true'
                            ],
                        ),

                    ),
                ),
                array(
                    'name' => 'style_section',
                    'label' => esc_html__('Style', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'portfolio_title_color',
                            'label' => esc_html__('content Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-portfolio-1 .item-title, .layout-portfolio-1 .item-location' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'portfolio',
                                'layout_portfolio' => ['portfolio-1']
                            ]
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Title Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .layout-portfolio-1 .item-title, {{WRAPPER}} .layout-portfolio-2 .item-title',
                            'condition' => [
                                'post_type' => 'portfolio',
                                'layout_portfolio' => ['portfolio-1','portfolio-2']
                            ]
                        ), 
                        array(
                            'name' => 'content_typography',
                            'label' => esc_html__('Title Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .layout-portfolio-2 .item-content',
                            'condition' => [
                                'post_type' => 'portfolio',
                                'layout_portfolio' => ['portfolio-2']
                            ]
                        ), 
                        array(
                            'name' => 'border_color',
                            'label' => esc_html__('Border Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-portfolio-1 .item-location' => 'border-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'portfolio',
                                'layout_portfolio' => ['portfolio-1']
                            ]
                        ),
                        array(
                            'name' => 'bg_overlay',
                            'label' => esc_html__('Overlay Background Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-portfolio-1 .pxl-overlay' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'portfolio',
                                'layout_portfolio' => ['portfolio-1']
                            ]
                        ),
                        array(
                            'name' => 'truncate_title',
                            'label' => esc_html__('Truncate Title', 'adsett'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'return_value' => 'yes',
                            'default' => 'yes',
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-3']
                            ],
                        ),
                        array(
                            'name'      => 'dark_style',
                            'label'     => esc_html__('Dark Style', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SWITCHER,
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-3']
                            ],
                        ),
                        array(
                            'name' => 'content_bg_color',
                            'label' => esc_html__('Content Background Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-post-3 .item-content' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-3']
                            ]
                        ),
                        array(
                            'name' => 'content_typo',
                            'label' => esc_html__('Content Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-post-carousel .item-content',
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1','post-2']
                            ]
                        ),
                        array( 
                            'name' => 'meta_color',
                            'label' => esc_html__('Meta Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-carousel .item-post-meta' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-post-carousel .item-post-meta .meta-inner > * + *:before' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1','post-2']
                            ]
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-carousel .item-title' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1','post-2']
                            ]
                        ),
                        array(
                            'name' => 'title_typo',
                            'label' => esc_html__('Title Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-post-carousel .item-title, {{WRAPPER}} .pxl-post-carousel .item-post-meta .number',
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1','post-2']
                            ]
                        ),
                        array(
                            'name' => 'excerpt_color',
                            'label' => esc_html__('Excerpt Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-carousel .item-excerpt' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1','post-2']
                            ]
                        ),
                        array(
                            'name' => 'img_bg_hover',
                            'label' => esc_html__('Image Background hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-carousel .item-featured .pxl-overlay' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1']
                            ]
                        ),
                        array(
                            'name' => 'img_bg_overlay',
                            'label' => esc_html__('Background Overlay', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-carousel .item-featured:before' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-2']
                            ]
                        ),
                        array(
                            'name' => 'content_bg_hover',
                            'label' => esc_html__('Background hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-post-1 .item-content-hover' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1']
                            ]
                        ),
                        array(
                            'name' => 'meta_hover_color',
                            'label' => esc_html__('Meta Hover Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-post-1 .item-content-hover .item-post-meta' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .layout-post-1 .item-content-hover .item-post-meta .meta-inner > * + *:before' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1']
                            ]
                        ),
                        array(
                            'name' => 'excerpt_hover_color',
                            'label' => esc_html__('Excerpt Hover Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .layout-post-1 .item-content-hover .item-excerpt' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1']
                            ]
                        ),
                        array(
                            'name' => 'css_filters',
                            'label' => esc_html__('CSS Filters', 'adsett' ),
                            'type' => \Elementor\Group_Control_Css_Filter::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .layout-post-1 .item-featured img',
                            'condition' => [
                                'post_type' => 'post',
                                'layout_post' => ['post-1']
                            ]
                        ),
                    ),
                ),
                adsett_cursor_opts()
            ),
        ),
    ),
    adsett_get_class_widget_path()
);