<?php
$pt_supports = ['portfolio'];
pxl_add_custom_widget(
    array(
        'name'       => 'pxl_portfolio_spilt',
        'title'      => esc_html__('PXL Portfolio Spilt', 'adsett' ),
        'icon'       => 'eicon-post-list',
        'categories' => array('pxltheme-core'),
        'scripts'    => [
            'pxl-splitText', 
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'adsett' ),
                    'tab'      => 'layout',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'post_type',
                                'label'    => esc_html__( 'Select Post Type', 'adsett' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => adsett_get_post_type_options($pt_supports),
                                'default'  => 'portfolio'
                            )
                        ),
                        array(
                            array(
                                'name'    => 'layout_portfolio',
                                'label'   => esc_html__( 'Templates', 'adsett' ),
                                'type'    => 'layoutcontrol',
                                'default' => 'portfolio-spilt-1',
                                'options' => [
                                    'portfolio-spilt-1' => [
                                        'label' => esc_html__( 'Layout 1', 'adsett' ),
                                        'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_portfolio_spilt-1.jpg'
                                    ],
                                     
                                ],
                            ),
                        )
                    )
                ),
                
                array(
                    'name' => 'source_section',
                    'label' => esc_html__('Source', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'select_post_by',
                                'label'    => esc_html__( 'Select posts by', 'adsett' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => [
                                    'term_selected' => esc_html__( 'Terms selected', 'adsett' ),
                                    'post_selected' => esc_html__( 'Posts selected ', 'adsett' ),
                                ],
                                'default'  => 'term_selected'
                            ) 
                        ),
                        adsett_get_grid_term_by_posttype($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        adsett_get_grid_ids_by_posttype($pt_supports, ['custom_condition' => ['select_post_by' => 'post_selected']]),
                        adsett_get_grid_ids_unselected_by_posttype($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        array(
                            array(
                                'name'    => 'orderby',
                                'label'   => esc_html__('Order By', 'adsett' ),
                                'type'    => \Elementor\Controls_Manager::SELECT,
                                'default' => 'date',
                                'options' => [
                                    'date'   => esc_html__('Date', 'adsett' ),
                                    'ID'     => esc_html__('ID', 'adsett' ),
                                    'author' => esc_html__('Author', 'adsett' ),
                                    'title'  => esc_html__('Title', 'adsett' ),
                                    'rand'   => esc_html__('Random', 'adsett' ),
                                ],
                            ),
                            array(
                                'name'    => 'order',
                                'label'   => esc_html__('Sort Order', 'adsett' ),
                                'type'    => \Elementor\Controls_Manager::SELECT,
                                'default' => 'desc',
                                'options' => [
                                    'desc' => esc_html__('Descending', 'adsett' ),
                                    'asc'  => esc_html__('Ascending', 'adsett' ),
                                ],
                            ),
                            array(
                                'name'    => 'limit',
                                'label'   => esc_html__('Total items', 'adsett' ),
                                'type'    => \Elementor\Controls_Manager::NUMBER,
                                'default' => '4',
                            ),
                            array(
                                'name'        => 'img_size',
                                'label'       => esc_html__('Image Size', 'adsett' ),
                                'type'        => \Elementor\Controls_Manager::TEXT,
                                'description' =>  esc_html__('Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: full).', 'adsett')
                            ),
                        )
                    ),
                ),
                array(
                    'name' => 'display_section',
                    'label' => esc_html__('Display Options', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                         
                        array(
                            'name'      => 'show_excerpt',
                            'label'     => esc_html__('Show Excerpt', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SWITCHER,
                            'default'   => 'true',
                        ),
                        array(
                            'name'      => 'num_words',
                            'label'     => esc_html__('Number of Words', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::NUMBER,
                            'default'   => 50,
                            'condition' => [
                                'show_excerpt' => 'true',
                            ],
                        ),
                        array(
                            'name'      => 'show_button',
                            'label'     => esc_html__('Show Button Readmore', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SWITCHER,
                            'default'   => 'true',
                        ),
                        array(
                            'name'      => 'button_text',
                            'label'     => esc_html__('Button Text', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'show_button' => 'true',
                            ],
                        ),
                        
                    ),
                ),
                array(
                    'name' => 'style_section',
                    'label' => esc_html__('Style', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array( 
                        array(
                            'name' => 'content_bg',
                            'label' => esc_html__('Content Background Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-portfolio-spilt .portfolio-item .content-wrap' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-portfolio-spilt .portfolio-item .content-wrap .item-title' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Title Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-portfolio-spilt .portfolio-item .content-wrap .item-title',
                        ),
                        array(
                            'name' => 'excerpt_color',
                            'label' => esc_html__('Excerpt Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-portfolio-spilt .portfolio-item .content-wrap .item-excerpt' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                    ),
                ),
            ),
        ),
    ),
    adsett_get_class_widget_path()
);