<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_partner',
        'title' => esc_html__('PXL Partner', 'adsett' ),
        'icon' => 'eicon-image',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'content_section',
                    'label' => esc_html__('Content', 'adsett' ),
                    'tab' => 'content',
                    'controls' => array(
                        array(
                            'name' => 'partner_img',
                            'label' => esc_html__('Partner Image', 'adsett' ),
                            'type' => 'media',
                        ),
                        array(
                            'name'        => 'img_size',
                            'label'       => esc_html__('Image Size', 'adsett' ),
                            'type'        => \Elementor\Controls_Manager::TEXT,
                            'description' =>  esc_html__('Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).', 'adsett')
                        ),
                        array(
                            'name' => 'partner_max_width',
                            'label' => esc_html__('Max Width', 'adsett' ),
                            'type' => 'slider',
                            'description' => esc_html__('Enter number.', 'adsett' ),
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 800,
                                ],
                            ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-partner img' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name'         => 'partner_align',
                            'label'        => esc_html__( 'Alignment', 'adsett' ),
                            'type'         => 'choose',
                            'control_type' => 'responsive',
                            'options' => [
                                'start' => [
                                    'title' => esc_html__( 'Start', 'adsett' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'adsett' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'end' => [
                                    'title' => esc_html__( 'End', 'adsett' ),
                                    'icon' => 'eicon-text-align-right',
                                ]
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-partner' => 'justify-content: {{VALUE}};',
                                '{{WRAPPER}} .pxl-partner' => 'text-align: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'partner_link',
                            'label' => esc_html__('Link', 'adsett' ),
                            'type' => 'url',
                        ),
                        array(
                            'name' => 'css_filters',
                            'label' => esc_html__('CSS Filters', 'adsett' ),
                            'type' => \Elementor\Group_Control_Css_Filter::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-partner img',
                        ), 
                    ),
                ),
            ),
        ),
    ),
    adsett_get_class_widget_path()
);