<?php
$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
$custom_menus = array(
    '' => esc_html__('Default', 'adsett')
);
if ( is_array( $menus ) && ! empty( $menus ) ) {
    foreach ( $menus as $single_menu ) {
        if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->slug ) ) {
            $custom_menus[ $single_menu->slug ] = $single_menu->name;
        }
    }
} else {
    $custom_menus = '';
}
pxl_add_custom_widget(
    array(
        'name' => 'pxl_menu',
        'title' => esc_html__('Pxl Menu', 'adsett'),
        'icon' => 'eicon-nav-menu',
        'categories' => array('pxltheme-core'),
        'scripts' => array(),
        'params' => array(
            'sections' => array(
                 
                array(
                    'name' => 'source_section',
                    'label' => esc_html__('Source Settings', 'adsett'),
                    'tab' => 'content',
                    'controls' => array(
                        array(
                            'name' => 'type',
                            'label' => esc_html__('Type', 'adsett' ),
                            'type' => 'select',
                            'options' => [
                                '1' => esc_html__('Primary Menu', 'adsett'),
                                '2' => esc_html__('Menu Inner', 'adsett'),
                                '3' => esc_html__('Mobile Menu', 'adsett'),
                            ],
                            'default' => '1',
                        ),
                        array(
                            'name' => 'style',
                            'label' => esc_html__('Menu Style', 'adsett' ),
                            'type' => 'select',
                            'options' => [
                                'df' => esc_html__('Default', 'adsett'),
                                'vr' => esc_html__('Vertical', 'adsett'),
                            ],
                            'default' => '1',
                            'condition' => ['type' => '1']
                        ),
                        array(
                            'name' => 'inner_style',
                            'label' => esc_html__('Menu Style', 'adsett' ),
                            'type' => 'select',
                            'options' => [
                                'df' => esc_html__('Default', 'adsett'),
                                'hr' => esc_html__('Horizontal', 'adsett'),
                            ],
                            'default' => '1',
                            'condition' => ['type' => '2']
                        ),
                        array(
                            'name' => 'menu',
                            'label' => esc_html__('Select Menu', 'adsett'),
                            'type' => 'select',
                            'options' => $custom_menus,
                        ),
                        array(
                            'name'         => 'align',
                            'label'        => esc_html__( 'Alignment', 'adsett' ),
                            'type'         => 'choose',
                            'control_type' => 'responsive',
                            'options' => [
                                'start' => [
                                    'title' => esc_html__( 'Start', 'adsett' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'adsett' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'end' => [
                                    'title' => esc_html__( 'End', 'adsett' ),
                                    'icon' => 'eicon-text-align-right',
                                ]
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-primary-menu, {{WRAPPER}} .style-vr .pxl-primary-menu > li,  {{WRAPPER}} .pxl-mobile-menu' => 'justify-content: {{VALUE}};'
                            ],
                            'condition' => [
                                'type' => ['1','3'],
                            ]
                        ),
                        
                    ),
                ),
                array(
                    'name' => 'first_section',
                    'label' => esc_html__('Style First Level', 'adsett'),
                    'tab' => 'content',
                    'condition' => [
                        'type' => ['1','3'],
                    ],
                    'controls' => array(
                        array(
                            'name' => 'color',
                            'label' => esc_html__('Color', 'adsett' ),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu > li > a' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-mobile-menu > li > a' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu > li > .main-menu-toggle' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-mobile-menu > li > .main-menu-toggle' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu > li > a span:before' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'color_hover',
                            'label' => esc_html__('Color Hover', 'adsett' ),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu > li > a:hover'                      => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu > li.current-menu-item > a'          => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu > li.current-menu-ancestor > a'      => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu > li.current-menu-item > .main-menu-toggle' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu > li.current-menu-ancestor > .main-menu-toggle'   => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu > li.current-menu-item > a span:before' => 'background-color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu > li.current-menu-ancestor > a span:before'   => 'background-color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-mobile-menu > li > a:hover'                       => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu > li:hover > .main-menu-toggle' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-mobile-menu > li:hover > .main-menu-toggle'  => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu > li:hover > a span:before' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'typography',
                            'label' => esc_html__('Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu > li > a, {{WRAPPER}} .pxl-nav-menu .pxl-mobile-menu > li > a',
                        ),
                        array(
                            'name'  => 'show_arrow',
                            'label' => esc_html__('Show Arrow', 'adsett'),
                            'type'  => 'switcher',
                            'return_value' => 'yes',
                            'default' => 'yes',
                            'condition' => [
                                'type' => ['1'],
                            ],
                        ),
                        array(
                            'name' => 'arrow_color',
                            'label' => esc_html__('Arrow Color', 'adsett' ),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu > li.menu-item .main-menu-toggle' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-mobile-menu > li.menu-item .main-menu-toggle' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'item_space',
                            'label' => esc_html__('Item Space', 'adsett' ),
                            'type' => 'dimensions',
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', 'em', '%', 'rem' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-primary-menu > li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .pxl-mobile-menu > li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'sub_section',
                    'label' => esc_html__('Style Sub Level', 'adsett'),
                    'tab' => 'content',
                    'condition' => [
                        'type' => ['1','3'],
                    ],
                    'controls' => array(
                        array(
                            'name' => 'sub_color',
                            'label' => esc_html__('Color', 'adsett' ),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu li .sub-menu a' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-mobile-menu li .sub-menu a' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'sub_color_hover',
                            'label' => esc_html__('Color Hover', 'adsett' ),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu li .sub-menu a:hover' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-nav-menu .pxl-mobile-menu li .sub-menu a:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'sub_typography',
                            'label' => esc_html__('Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-nav-menu .pxl-primary-menu li .sub-menu a, {{WRAPPER}} .pxl-nav-menu .pxl-mobile-menu li .sub-menu a',
                        ),
                    ),
                ),

                array(
                    'name' => 'nav_section',
                    'label' => esc_html__('Style', 'adsett'),
                    'tab' => 'content',
                    'condition' => [
                        'type' => ['2'],
                    ],
                    'controls' => array(
                        array(
                            'name' => 'nav_color',
                            'label' => esc_html__('Color', 'adsett' ),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-nav-menu .pxl-nav-inner a' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'nav_color_hover',
                            'label' => esc_html__('Color Hover', 'adsett' ),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-nav-menu .pxl-nav-inner a:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'nav_typography',
                            'label' => esc_html__('Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-nav-menu .pxl-nav-inner a',
                        ),
                        array(
                            'name' => 'nav_item_space',
                            'label' => esc_html__('Item Space', 'adsett' ),
                            'type' => 'slider',
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-nav-menu .pxl-nav-inner li + li' => 'margin-top: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                    ),
                ),
            ),
        ),
    ),
    adsett_get_class_widget_path()
);