<?php
pxl_add_custom_widget(
    array(
        'name'       => 'pxl_link',
        'title'      => esc_html__( 'PXL Link', 'adsett' ),
        'icon'       => 'eicon-editor-link',
        'categories' => array('pxltheme-core'),
        'params'     => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name'    => 'style',
                            'label'   => esc_html__( 'Link Style', 'adsett' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'default' => 'default',
                            'options' => [
                                'default' => esc_html__( 'Default', 'adsett' ),
                                'circle'  => esc_html__( 'Circle Icon', 'adsett' ),
                            ]
                        ),
                        array(
                            'name' => 'text',
                            'label' => esc_html__('Text', 'adsett'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'default' => esc_html__( 'Link More', 'adsett' ),
                        ),
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'adsett'),
                            'type' => \Elementor\Controls_Manager::URL,
                            'label_block' => true,
                            'default' => [
                                'url' => '#',
                            ],
                        ),
                    )
                ),
                array(
                    'name' => 'icon_section',
                    'label' => esc_html__('Icon Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'pxl_icon',
                            'label' => esc_html__('Icon', 'adsett' ),
                            'type' => 'icons',
                            'label_block' => true,
                            'fa4compatibility' => 'icon',
                        ),
                        array(
                            'name' => 'icon_align',
                            'label' => esc_html__('Icon Position', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'right',
                            'options' => [
                                'right' => esc_html__('After', 'adsett' ),
                                'left' => esc_html__('Before', 'adsett' ),
                            ],
                            
                        ),
                        array(
                            'name' => 'icon_space_right',
                            'label' => esc_html__('Icon Space Right', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon.left' => 'margin-right: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'icon_align' => ['left'],
                            ],
                        ),
                        array(
                            'name' => 'icon_space_left',
                            'label' => esc_html__('Icon Space Left', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon.right' => 'margin-left: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'icon_align' => ['right'],
                            ],
                        ),
                        array(
                            'name' => 'icon_font_size',
                            'label' => esc_html__('Icon Font Size', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'icon_border_color',
                            'label' => esc_html__('Icon Border Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-link.circle .pxl-icon' => 'border-color: {{VALUE}};',
                            ],
                            'condition' => [ 'style' => 'circle']
                        ), 
                        array(
                            'name' => 'icon_border_color_hover',
                            'label' => esc_html__('Icon Border Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-link.circle:hover .pxl-icon' => 'border-color: {{VALUE}};',
                            ],
                            'condition' => [ 'style' => 'circle']
                        ), 
                    ),
                ),
                array(
                    'name' => 'style_section',
                    'label' => esc_html__('Style Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array( 
                        array(
                            'name' => 'link_padding',
                            'label' => esc_html__('Padding', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                         
                        array(
                            'name' => 'typography',
                            'label' => esc_html__('Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-link',
                        ),
                        
                        array(
                            'name' => 'link_color',
                            'label' => esc_html__('Text Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-link' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'link_color_hover',
                            'label' => esc_html__('Text Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-link:hover' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                       
                        array(
                            'name' => 'border_type',
                            'label' => esc_html__( 'Border Type', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => esc_html__( 'None', 'adsett' ),
                                'solid' => esc_html__( 'Solid', 'adsett' ),
                                'double' => esc_html__( 'Double', 'adsett' ),
                                'dotted' => esc_html__( 'Dotted', 'adsett' ),
                                'dashed' => esc_html__( 'Dashed', 'adsett' ),
                                'groove' => esc_html__( 'Groove', 'adsett' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-link' => 'border-style: {{VALUE}} !important;',
                            ],
                            'condition' => [ 'style' => 'circle']
                        ),
                        
                        array(
                            'name' => 'border_width',
                            'label' => esc_html__( 'Border Width', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-link' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                            ],
                            'responsive' => true,
                            'condition' => [ 
                                'style' => 'circle',
                                'border_type!' => ''
                            ]
                        ),
                        array(
                            'name' => 'border_color',
                            'label' => esc_html__( 'Border Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-link' => 'border-color: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'style' => 'circle',
                                'border_type!' => ''
                            ],
                        ),
                        array(
                            'name' => 'border_color_hover',
                            'label' => esc_html__( 'Border Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-link:hover' => 'border-color: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'style' => 'circle',
                                'border_type!' => ''
                            ],
                        ),
                          
                    ),
                ),
                 
            ),
        )
    ),
    adsett_get_class_widget_path()
);