<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_layer',
        'title' => esc_html__('PXL Layer', 'adsett' ),
        'icon' => 'eicon-image',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'content_section',
                    'label' => esc_html__('Content', 'adsett' ),
                    'tab' => 'content',
                    'controls' => array_merge(
                        array(
                            array(
                                'name' => 'layer_img',
                                'label' => esc_html__('Layer Image', 'adsett' ),
                                'type' => 'media',
                            ),
                            array(
                                'name' => 'bg_color',
                                'label' => esc_html__('Background Color', 'adsett' ),
                                'type' => 'color',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-layer' => 'background-color: {{VALUE}};'
                                ],
                            ), 
                            array(
                                'name'        => 'layer_width',
                                'label'       => esc_html__('Width', 'adsett' ),
                                'type'        => 'slider',
                                'description' => esc_html__('Enter number.', 'adsett' ),
                                'size_units'  => [ 'px', '%' ],
                                'range'       => [
                                    'px' => [
                                        'min' => 10,
                                        'max' => 2000,
                                    ],
                                    '%' => [
                                        'min' => 1,
                                        'max' => 100,
                                    ],
                                ],
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-layer .layer-img' => 'width: {{SIZE}}{{UNIT}};',
                                ],
                                'condition'     => [
                                    'layer_img[url]!' => ''
                                ] 
                            ),
                        ),
                        adsett_position_option_base([
                            'prefix'          => 'layer_',
                            'selectors_class' => '.pxl-layer',
                        ]), 
                        adsett_parallax_effect_option([
                            'prefix'    => 'layer_',
                        ]),
                        array(
                            array(
                                'name'      => 'z_index',
                                'label'     => esc_html__( 'Z-Index', 'adsett' ),
                                'type'      => 'number',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-layer' => 'z-index: {{VALUE}};',
                                ]
                            )
                        )
                    ),
                ),
            ),
        ),
    ),
    adsett_get_class_widget_path()
);