<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_image_text',
        'title' => esc_html__('PXL Image Text', 'adsett' ),
        'icon' => 'eicon-image',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'content_section',
                    'label' => esc_html__('Content', 'adsett' ),
                    'tab' => 'content',
                    'controls' => array_merge(
                        array(
                            array(
                                'name' => 'image',
                                'label' => esc_html__('Image', 'adsett' ),
                                'type' => 'media',
                            ),
                            array(
                                'name' => 'img_size',
                                'label' => esc_html__('Image Size', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::TEXT,
                                'description' =>  esc_html__('Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).', 'adsett')
                            ),
                            array(
                                'name' => 'img_max_width',
                                'label' => esc_html__('Image Max Width', 'adsett' ),
                                'type' => 'slider',
                                'description' => esc_html__('Enter number.', 'adsett' ),
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                    ],
                                ],
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-img-text img' => 'max-width: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'text_max_width',
                                'label' => esc_html__('Text Max Width', 'adsett' ),
                                'type' => 'slider',
                                'description' => esc_html__('Enter number.', 'adsett' ),
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 1500,
                                    ],
                                ],
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-img-text .title-outer,{{WRAPPER}} .pxl-img-text .title-inner' => 'max-width: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name'         => 'img_align',
                                'label'        => esc_html__( 'Alignment', 'adsett' ),
                                'type'         => 'choose',
                                'control_type' => 'responsive',
                                'options' => [
                                    'start' => [
                                        'title' => esc_html__( 'Start', 'adsett' ),
                                        'icon' => 'eicon-text-align-left',
                                    ],
                                    'center' => [
                                        'title' => esc_html__( 'Center', 'adsett' ),
                                        'icon' => 'eicon-text-align-center',
                                    ],
                                    'end' => [
                                        'title' => esc_html__( 'End', 'adsett' ),
                                        'icon' => 'eicon-text-align-right',
                                    ]
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-img-text' => 'justify-content: {{VALUE}};',
                                    '{{WRAPPER}} .pxl-img-text' => 'text-align: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'title',
                                'label' => esc_html__('Title', 'adsett' ),
                                'type' => 'textarea',
                            ) 
                        ),  
                        adsett_position_option([
                            'prefix' => 'text_',
                            'selectors_class' => '.pxl-img-text .title-outer, {{WRAPPER}} .pxl-img-text .title-inner',
                        ])
                    ),  
                ),
                array(
                    'name' => 'style_section',
                    'label' => esc_html__('Style', 'adsett' ),
                    'tab' => 'style',
                    'controls' => array(
                        array(
                            'name' => 'title_outer_color',
                            'label' => esc_html__('Title Outer Color', 'adsett' ),
                            'type' => 'color',
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-img-text .title-outer' => 'color: {{VALUE}};',
                            ]
                        ),
                        array(
                            'name' => 'title_inner_color',
                            'label' => esc_html__('Title Inner Color', 'adsett' ),
                            'type' => 'color',
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-img-text .title-inner' => 'color: {{VALUE}};',
                            ]
                        ),
                        array(
                            'name' => 'title_outer_color_typography',
                            'label' => esc_html__('Title Outer Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-img-text .title-outer,{{WRAPPER}} .pxl-img-text .title-inner',
                        ),
                        
                         
                    ),
                ),
            ),
        ),
    ),
    adsett_get_class_widget_path()
);