<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_image_before_after',
        'title' => esc_html__('Pxl Image Before After', 'adsett'),
        'icon' => 'eicon-image-rollover',
        'categories' => array('pxltheme-core'),
        'scripts' => [
            'event-move',
            'twentytwenty',
        ],
        'styles' => array('twentytwenty'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'layout_section',
                    'label' => esc_html__('Layout', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'adsett' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_image_before_after-1.jpg'
                                ],
                                 
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'adsett'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'before_image',
                            'label' => esc_html__('Before Image', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        array(
                            'name' => 'after_image',
                            'label' => esc_html__('After Image', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        array(
                            'name' => 'before_text',
                            'label' => esc_html__('Before Text', 'adsett'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                        ),
                        array(
                            'name' => 'after_text',
                            'label' => esc_html__('After Text', 'adsett'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                        ),
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => esc_html__( 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).', 'adsett' ),
                            'condition' => [
                                'layout' => '1',
                            ],
                        ),
                    ),
                ),
            ),
        ),
    ),
    adsett_get_class_widget_path()
);