<?php
pxl_add_custom_widget(
    [
        'name' => 'pxl_image',
        'title' => esc_html__('PXL Image', 'adsett' ),
        'icon' => 'eicon-image',
        'categories' => ['pxltheme-core'],
        'params' => [
            'sections' => [
                [
                    'name'     => 'content_section',
                    'label'    => esc_html__( 'Image', 'adsett' ),
                    'tab'      => 'content',
                    'controls' => [
                        [
                            'name' => 'image',
                            'label' => esc_html__( 'Choose Image', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'dynamic' => [
                                'active' => true,
                            ],
                            'default' => [
                                'url' => \Elementor\Utils::get_placeholder_image_src()
                            ],
                        ],
                        [
                            'name' => 'image',
                            'label' => esc_html__( 'Image Size', 'adsett' ),
                            'type' => \Elementor\Group_Control_Image_Size::get_type(),
                            'control_type' => 'group',
                            'default' => 'full',  
                        ],
                        [
                            'name' => 'align',
                            'label' => esc_html__( 'Alignment', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'adsett' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'adsett' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'adsett' ),
                                    'icon' => 'eicon-text-align-right',
                                ],
                            ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                            ],
                        ],
                        [
                            'name' => 'link_to',
                            'label' => esc_html__( 'Link', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'none',
                            'options' => [
                                'none' => esc_html__( 'None', 'adsett' ),
                                'file' => esc_html__( 'Media File', 'adsett' ),
                                'custom' => esc_html__( 'Custom URL', 'adsett' ),
                            ],
                        ],
                        [
                            'name' => 'link',
                            'label' => esc_html__( 'Link', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'dynamic' => [
                                'active' => true,
                            ],
                            'placeholder' => esc_html__( 'https://your-link.com', 'adsett' ),
                            'condition' => [
                                'link_to' => 'custom',
                            ],
                            'show_label' => false,
                        ],
                        [
                            'name' => 'open_lightbox',
                            'label' => esc_html__( 'Lightbox', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'default',
                            'options' => [
                                'default' => esc_html__( 'Default', 'adsett' ),
                                'yes' => esc_html__( 'Yes', 'adsett' ),
                                'no' => esc_html__( 'No', 'adsett' ),
                            ],
                            'condition' => [
                                'link_to' => 'file',
                            ],
                        ]
                    ],
                ],  
                [
                    'name' => 'parallax_section',
                    'label' => esc_html__('Parallax Settings', 'adsett' ),
                    'tab'      => 'content',
                    'controls' => [
                        [
                            'name' => 'pxl_parallax',
                            'label' => esc_html__( 'Parallax Type', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                ''        => esc_html__( 'None', 'adsett' ),
                                'x'       => esc_html__( 'Transform X', 'adsett' ),
                                'y'       => esc_html__( 'Transform Y', 'adsett' ),
                                'z'       => esc_html__( 'Transform Z', 'adsett' ),
                                'rotateX' => esc_html__( 'RotateX', 'adsett' ),
                                'rotateY' => esc_html__( 'RotateY', 'adsett' ),
                                'rotateZ' => esc_html__( 'RotateZ', 'adsett' ),
                                'scaleX'  => esc_html__( 'ScaleX', 'adsett' ),
                                'scaleY'  => esc_html__( 'ScaleY', 'adsett' ),
                                'scaleZ'  => esc_html__( 'ScaleZ', 'adsett' ),
                                'scale'   => esc_html__( 'Scale', 'adsett' ),
                            ],
                        ],
                        [
                            'name' => 'parallax_value',
                            'label' => esc_html__('Value', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '',
                            'condition' => [ 'pxl_parallax!' => '']  
                        ],
                        [
                            'name' => 'pxl_parallax_screen',
                            'label'   => esc_html__( 'Parallax In Screen', 'adsett' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'control_type' => 'responsive',
                            'default' => '',
                            'options' => array(
                                '' => esc_html__( 'Default', 'adsett' ),
                                'no'   => esc_html__( 'No', 'adsett' ),
                            ),
                            'prefix_class' => 'pxl-parallax%s-',
                            'condition' => [ 'pxl_parallax!' => '']  
                        ]
                    ]
                ],
                [
                    'name'     => 'bg_parallax_section',
                    'label'    => esc_html__('Background Parallax', 'adsett' ),
                    'tab'      => 'content',
                    'controls' => [
                        [
                            'name'    => 'pxl_bg_parallax',
                            'label'   => esc_html__( 'Background Parallax Type', 'adsett' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                ''                  => esc_html__( 'None', 'adsett' ),
                                'basic'             => esc_html__( 'Basic', 'adsett' ),
                                'rotate'            => esc_html__( 'Rotate', 'adsett' ),
                                'mouse-move'        => esc_html__( 'Mouse Move', 'adsett' ),
                                'mouse-move-rotate' => esc_html__( 'Mouse Move Rotate', 'adsett' ),
                            ],
                        ],
                        [
                            'name' => 'bg_parallax_width',
                            'label' => esc_html__('Background Width', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'default' => [
                                'unit' => '%',
                            ],
                            'tablet_default' => [
                                'unit' => '%',
                            ],
                            'mobile_default' => [
                                'unit' => '%',
                            ],
                            'size_units' => [ '%', 'px', 'vw' ],
                            'range' => [
                                '%' => [
                                    'min' => 1,
                                    'max' => 100,
                                ],
                                'px' => [
                                    'min' => 1,
                                    'max' => 1920,
                                ],
                                'vw' => [
                                    'min' => 1,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-wg' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [ 'pxl_bg_parallax!' => '']  
                        ],
                        [
                            'name' => 'bg_parallax_height',
                            'label' => esc_html__('Background Height', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'default' => [
                                'unit' => 'px',
                            ],
                            'tablet_default' => [
                                'unit' => 'px',
                            ],
                            'mobile_default' => [
                                'unit' => 'px',
                            ],
                            'size_units' => [ 'px', 'vh' ],
                            'range' => [
                                'px' => [
                                    'min' => 1,
                                    'max' => 1000,
                                ],
                                'vh' => [
                                    'min' => 1,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-wg' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [ 'pxl_bg_parallax!' => '']  
                        ],
                    ]
                ],
                [
                    'name'     => 'style_section',
                    'label'    => esc_html__( 'Style', 'adsett' ),
                    'tab'      => 'style',
                    'controls' => [
                        [
                            'name'        => 'width',
                            'label' => esc_html__( 'Width', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'default' => [
                                'unit' => '%',
                            ],
                            'tablet_default' => [
                                'unit' => '%',
                            ],
                            'mobile_default' => [
                                'unit' => '%',
                            ],
                            'size_units' => [ '%', 'px', 'vw' ],
                            'range' => [
                                '%' => [
                                    'min' => 1,
                                    'max' => 100,
                                ],
                                'px' => [
                                    'min' => 1,
                                    'max' => 1000,
                                ],
                                'vw' => [
                                    'min' => 1,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} img' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ],
                        [
                            'name'        => 'space',
                            'label' => esc_html__( 'Max Width', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'default' => [
                                'unit' => '%',
                            ],
                            'tablet_default' => [
                                'unit' => '%',
                            ],
                            'mobile_default' => [
                                'unit' => '%',
                            ],
                            'size_units' => [ '%', 'px', 'vw' ],
                            'range' => [
                                '%' => [
                                    'min' => 1,
                                    'max' => 100,
                                ],
                                'px' => [
                                    'min' => 1,
                                    'max' => 1000,
                                ],
                                'vw' => [
                                    'min' => 1,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} img' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ],
                        [
                            'name'        => 'height',
                            'label' => esc_html__( 'Height', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'default' => [
                                'unit' => 'px',
                            ],
                            'tablet_default' => [
                                'unit' => 'px',
                            ],
                            'mobile_default' => [
                                'unit' => 'px',
                            ],
                            'size_units' => [ 'px', 'vh' ],
                            'range' => [
                                'px' => [
                                    'min' => 1,
                                    'max' => 1000,
                                ],
                                'vh' => [
                                    'min' => 1,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} img' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ],
                        [
                            'name'        => 'object-fit',
                            'label' => esc_html__( 'Object Fit', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'control_type' => 'responsive',
                            'condition' => [
                                'height[size]!' => '',
                            ],
                            'options' => [
                                '' => esc_html__( 'Default', 'adsett' ),
                                'fill' => esc_html__( 'Fill', 'adsett' ),
                                'cover' => esc_html__( 'Cover', 'adsett' ),
                                'contain' => esc_html__( 'Contain', 'adsett' ),
                            ],
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} img' => 'object-fit: {{VALUE}};',
                            ],
                        ],
                        [
                            'name'        => 'separator_panel_style',
                            'type' => \Elementor\Controls_Manager::DIVIDER,
                            'style' => 'thick',
                        ],
                        [
                            'name' => 'image_effects',
                            'control_type' => 'tab',
                            'tabs' => [
                                [
                                    'name' => 'normal',
                                    'label' => esc_html__('Normal', 'adsett' ),
                                    'type' => \Elementor\Controls_Manager::TAB,
                                    'controls' => [
                                        [
                                            'name'        => 'opacity',
                                            'label' => esc_html__( 'Opacity', 'adsett' ),
                                            'type' => \Elementor\Controls_Manager::SLIDER,
                                            'range' => [
                                                'px' => [
                                                    'max' => 1,
                                                    'min' => 0.10,
                                                    'step' => 0.01,
                                                ],
                                            ],
                                            'selectors' => [
                                                '{{WRAPPER}} img' => 'opacity: {{SIZE}};',
                                            ],
                                        ],
                                        [
                                            'name' => 'css_filters',
                                            'label' => esc_html__('CSS Filters', 'adsett' ),
                                            'type' => \Elementor\Group_Control_Css_Filter::get_type(),
                                            'control_type' => 'group',
                                            'selector' => '{{WRAPPER}} img',
                                        ],       
                                    ],
                                ],
                                [
                                    'name' => 'hover',
                                    'label' => esc_html__('Hover', 'adsett' ),
                                    'type' => \Elementor\Controls_Manager::TAB,
                                    'controls' => [
                                        [
                                            'name'        => 'opacity_hover',
                                            'label' => esc_html__( 'Opacity Hover', 'adsett' ),
                                            'type' => \Elementor\Controls_Manager::SLIDER,
                                            'range' => [
                                                'px' => [
                                                    'max' => 1,
                                                    'min' => 0.10,
                                                    'step' => 0.01,
                                                ],
                                            ],
                                            'selectors' => [
                                                '{{WRAPPER}}:hover img' => 'opacity: {{SIZE}};',
                                            ],
                                        ],
                                        [
                                            'name' => 'css_filters_hover',
                                            'label' => esc_html__('CSS Filters Hover', 'adsett' ),
                                            'type' => \Elementor\Group_Control_Css_Filter::get_type(),
                                            'control_type' => 'group',
                                            'selector' => '{{WRAPPER}}:hover img',
                                        ],  
                                        [
                                            'name' => 'background_hover_transition',
                                            'label' => esc_html__( 'Transition Duration', 'adsett' ),
                                            'type' => \Elementor\Controls_Manager::SLIDER,
                                            'range' => [
                                                'px' => [
                                                    'max' => 3,
                                                    'step' => 0.1,
                                                ],
                                            ],
                                            'selectors' => [
                                                '{{WRAPPER}} img' => 'transition-duration: {{SIZE}}s',
                                            ],
                                        ],
                                        [
                                            'name' => 'hover_animation',
                                            'label' => esc_html__( 'Hover Animation', 'adsett' ),
                                            'type' => \Elementor\Controls_Manager::HOVER_ANIMATION,
                                        ]     
                                    ]
                                ]
                            ],
                             
                        ], 
                        [
                            'name' => 'image_border',
                            'type' => \Elementor\Group_Control_Border::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} img, {{WRAPPER}} .pxl-bg-parallax',
                            'separator' => 'before',
                        ],
                        [
                            'name'         => 'image_border_radius',
                            'label'        => esc_html__( 'Border Radius', 'adsett' ),
                            'type'         => \Elementor\Controls_Manager::DIMENSIONS,
                            'control_type' => 'responsive',
                            'size_units'   => [ 'px', '%' ],
                            'selectors'    => [
                                '{{WRAPPER}} img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .pxl-bg-parallax' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ],
                        [
                            'name'         => 'image_box_shadow',
                            'label'        => esc_html__( 'Box Shadow', 'adsett' ),
                            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
                            'control_type' => 'group',
                            'exclude' => [
                                'box_shadow_position',
                            ],
                            'selector' => '{{WRAPPER}} img',
                        ]   
                    ],
                ],  
                [
                    'name' => 'custom_style_section',
                    'label' => esc_html__('Custom Style', 'adsett' ),
                    'tab'      => 'style',
                    'controls' => [
                        [
                            'name' => 'custom_style',
                            'label' => esc_html__( 'Style', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                ''           => esc_html__( 'None', 'adsett' ),
                                'bg-halp' => esc_html__( 'Background Halp', 'adsett' ),
                                'move-from-left' => esc_html__( 'Move From Left', 'adsett' ),
                                'move-from-right' => esc_html__( 'Move From Right', 'adsett' ),
                                'skew-in' => esc_html__( 'Skew In', 'adsett' ),
                            ],
                        ],
                        [
                            'name' => 'bg_color',
                            'label' => esc_html__('Background color', 'adsett'),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-wg.bg-halp:before' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [ 'custom_style' => 'bg-halp']  
                        ],
                    ]
                ],
            ], 
        ],
    ],
    adsett_get_class_widget_path()
);