<?php
pxl_add_custom_widget(
    array(
        'name'       => 'pxl_horizontal_scroll',
        'title'      => esc_html__( 'PXL Horizontal Scroll', 'adsett' ),
        'icon'       => 'eicon-slider-push',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'adsett' ),
                    'tab'      => 'layout',
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Layout', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/h-scrolls-1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__( 'Layout 2', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/h-scrolls-2.jpg'
                                ],
                            ],
                        ),
                    )
                ),
                array(
                    'name' => 'content_section',
                    'label' => esc_html__('Content', 'adsett' ),
                    'tab' => 'content',
                    'controls' => array(
                        array(
                            'name' => 'revesal',
                            'label' => esc_html__('Revesal Scroll', 'adsett'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                        ),
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height).',
                            'condition'   => ['layout' => '1']
                        ),
                        array(
                            'name'        => 'img_gallery',
                            'label'       => esc_html__( 'Gallery', 'adsett' ),
                            'type'        => 'gallery',
                            'label_block' => true,
                            'condition'   => ['layout' => '1']
                        ),
                        array(
                            'name'        => 'title',
                            'label'       => esc_html__( 'Title', 'adsett' ),
                            'type'        => 'textarea',
                            'label_block' => true,
                            'condition'   => ['layout' => '2']
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'adsett' ),
                            'description' => esc_html__('Color only worked when Gradient color is not set', 'adsett' ),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-horizontal-scroll .scroll-text' => 'color: {{VALUE}};',
                            ],
                            'condition'   => ['layout' => '2']
                        ),
                        array(
                            'name'         => 'title_gradient_color',
                            'label' => esc_html__( 'title Gradient Color', 'adsett' ),
                            'type'         => \Elementor\Group_Control_Background::get_type(),
                            'control_type' => 'group',
                            'types' => [ 'gradient' ],
                            'selector'     => '{{WRAPPER}} .pxl-horizontal-scroll .scroll-text',
                            'condition'   => ['layout' => '2']
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Title Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-horizontal-scroll .scroll-text',
                            'condition'   => ['layout' => '2']
                        ),
                    ),
                ),
                   
            ),
        ),
    ),
    adsett_get_class_widget_path()
);