<?php
pxl_add_custom_widget(
    array(
        'name'       => 'pxl_heading',
        'title'      => esc_html__( 'PXL Heading', 'adsett' ),
        'icon'       => 'eicon-t-letter',
        'categories' => array('pxltheme-core'),
        'scripts'    => array(
            'pxl-splitText'
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'adsett' ),
                    'tab'      => 'layout',
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Layout', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/heading-1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__( 'Layout 2', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/heading-2.jpg'
                                ]
                            ],
                        ),
                    )
                ),
                array(
                    'name' => 'subtitle_section',
                    'label' => esc_html__('Sub Title', 'adsett' ),
                    'tab' => 'content',
                    'controls' => array(
                        array(
                            'name' => 'sub_title',
                            'label' => esc_html__('Sub Title', 'adsett' ),
                            'type' => 'textarea',
                            'label_block' => true,
                        ),
                        array(
                            'name'      => 'sub_title_on_bottom',
                            'label'     => esc_html__('On Bottom', 'adsett' ),
                            'type'      => 'switcher',
                            'default'   => 'false',
                        ),
                    ),
                ),
                array(
                    'name' => 'title_section',
                    'label' => esc_html__('Title', 'adsett' ),
                    'tab' => 'content',
                    'controls' => array(
                        array(
                            'name' => 'title',
                            'label' => esc_html__('Title', 'adsett' ),
                            'type' => 'textarea',
                            'default' => 'Fine Architect to Build',
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'title_tag',
                            'label' => esc_html__('Heading HTML Tag', 'adsett' ),
                            'type' => 'select',
                            'options' => [
                                'h1' => 'H1',
                                'h2' => 'H2',
                                'h3' => 'H3',
                                'h4' => 'H4',
                                'h5' => 'H5',
                                'h6' => 'H6',
                                'div' => 'div',
                                'span' => 'span',
                                'p' => 'p',
                            ],
                            'default' => 'h3',
                        ),
                    ),
                ),
                
                array(
                    'name' => 'general_style_section',
                    'label' => esc_html__('General Style', 'adsett' ),
                    'tab' => 'style',
                    'controls' => array(  
                        array(
                            'name' => 'text_align',
                            'label' => esc_html__('Alignment', 'adsett' ),
                            'type' => 'choose',
                            'control_type' => 'responsive',
                            'options' => [
                                'start' => [
                                    'title' => esc_html__( 'Start', 'adsett' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'adsett' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'end' => [
                                    'title' => esc_html__( 'End', 'adsett' ),
                                    'icon' => 'eicon-text-align-right',
                                ]
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-heading-wrap' => 'justify-content: {{VALUE}};',
                                '{{WRAPPER}} .pxl-heading-inner' => 'text-align: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name'  => 'max_width',
                            'label' => esc_html__( 'Max Width', 'adsett' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 100,
                                    'max' => 1920,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-heading-inner' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                       
                    ),
                ),
                array(
                    'name' => 'title_style_section',
                    'label' => esc_html__('Title Style', 'adsett' ),
                    'tab' => 'style',
                    'controls' => array_merge(
                        array(  
                            array(
                                'name' => 'title_color',
                                'label' => esc_html__('Title Color', 'adsett' ),
                                'type' => 'color',
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-heading-wrap .heading-title' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'title_typography',
                                'label' => esc_html__('Title Typography', 'adsett' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .pxl-heading-wrap .heading-title',
                            ),
                            array(
                                'name' => 'space_bottom',
                                'label' => esc_html__('Bottom Space (px)', 'adsett' ),
                                'type' => 'slider',
                                'description' => esc_html__('Enter number.', 'adsett' ),
                                'size_units' => [ 'px' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                    ],
                                ],
                                'default'    => [
                                    'unit' => 'px'
                                ],
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-heading-wrap .heading-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'title_split_text_anm',
                                'label' => esc_html__('Split Text Animation', 'adsett' ),
                                'type' => 'select',
                                'options' => [
                                    ''               => esc_html__( 'None', 'adsett' ),
                                    'split-in-fade' => esc_html__( 'In Fade', 'adsett' ),
                                    'split-in-right' => esc_html__( 'In Right', 'adsett' ),
                                    'split-in-left'  => esc_html__( 'In Left', 'adsett' ),
                                    'split-in-up'    => esc_html__( 'In Up', 'adsett' ),
                                    'split-in-down'  => esc_html__( 'In Down', 'adsett' ),
                                    'split-in-rotate'  => esc_html__( 'In Rotate', 'adsett' ),
                                    'split-in-scale'  => esc_html__( 'In Scale', 'adsett' ),
                                ],
                                'default' => '',
                            ),

                        ),
                        adsett_elementor_animation_opts([
                            'name'   => 'title',
                            'label' => '',
                        ])
                    ),
                ),
                array(
                    'name' => 'subtitle_style_section',
                    'label' => esc_html__('Sub Title Style', 'adsett' ),
                    'tab' => 'style',
                    'controls' => array_merge(
                        array(
                            array(
                                'name' => 'sub_title_color',
                                'label' => esc_html__('Sub Title Color', 'adsett' ),
                                'type' => 'color',
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-heading-wrap .heading-subtitle' => 'color: {{VALUE}};',
                                    '{{WRAPPER}} .pxl-heading-wrap .heading-subtitle span:before' => 'background-color: {{VALUE}};',
                                    '{{WRAPPER}} .pxl-heading-wrap .heading-subtitle span:after' => 'background-color: {{VALUE}};',
                                ],
                                'separator' => 'before'
                            ),
                            array(
                                'name' => 'sub_title_typography',
                                'label' => esc_html__('Sub Title Typography', 'adsett' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .pxl-heading-wrap .heading-subtitle',
                            ),
                            array(
                                'name'  => 'sub_title_space',
                                'label' => esc_html__( 'Bottom Space', 'adsett' ),
                                'type'  => 'slider',
                                'control_type' => 'responsive',
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-heading-wrap .heading-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'subtitle_split_text_anm',
                                'label' => esc_html__('Split Text Animation', 'adsett' ),
                                'type' => 'select',
                                'options' => [
                                    ''               => esc_html__( 'None', 'adsett' ),
                                    'split-in-fade' => esc_html__( 'In Fade', 'adsett' ),
                                    'split-in-right' => esc_html__( 'In Right', 'adsett' ),
                                    'split-in-left'  => esc_html__( 'In Left', 'adsett' ),
                                    'split-in-up'    => esc_html__( 'In Up', 'adsett' ),
                                    'split-in-down'  => esc_html__( 'In Down', 'adsett' ),
                                    'split-in-rotate'  => esc_html__( 'In Rotate', 'adsett' ),
                                    'split-in-scale'  => esc_html__( 'In Scale', 'adsett' ),
                                ],
                                'default' => '',
                            ),
                        ),
                        adsett_elementor_animation_opts([
                            'name'   => 'sub_title',
                            'label' => '',
                        ])
                        
                    ),
                ),
                array(
                    'name' => 'border_style_section',
                    'label' => esc_html__('Border', 'adsett' ),
                    'tab' => 'style',
                    'controls' => array(  
                        array(
                            'name' => 'hd_border',
                            'label' => esc_html__('Border', 'adsett' ),
                            'type' => 'select',
                            'options'      => array(
                                ''        => esc_html__( 'None', 'adsett' ),
                                'bd-left'    => esc_html__( 'Border Left', 'adsett' ),
                                'bd-right'   => esc_html__( 'Border Right', 'adsett' )
                            ),
                            'prefix_class' => 'pxl-hd-' 
                        ), 
                        array(
                            'name'  => 'bd_width',
                            'label' => esc_html__( 'Border Width (px)', 'adsett' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 1,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}}.pxl-hd-bd-left .elementor-widget-container:before, {{WRAPPER}}.pxl-hd-bd-right .elementor-widget-container:before' => 'width: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}}.pxl-hd-bd-left .pxl-heading-wrap' => 'padding-left: calc({{SIZE}}{{UNIT}} + 20px);',
                                '{{WRAPPER}}.pxl-hd-bd-right .pxl-heading-wrap' => 'padding-right: calc({{SIZE}}{{UNIT}} + 20px);',
                            ],
                        ),
                        array(
                            'name' => 'border_color',
                            'label' => esc_html__('Border Color', 'adsett' ),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}}.pxl-hd-bd-left .elementor-widget-container:before, {{WRAPPER}}.pxl-hd-bd-right .elementor-widget-container:before' => 'background-color: {{VALUE}};',
                            ],
                        ),
                    )
                ),  
            ),
        ),
    ),
    adsett_get_class_widget_path()
);