<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_gallery_carousel',
        'title' => esc_html__('PXL Gallery Carousel', 'adsett'),
         'icon' => 'eicon-slider-push',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'swiper',
            'adsett-swiper',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'layout_section',
                    'label' => esc_html__('Layout', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Layout', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_gallery_carousel-1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__( 'Layout 2', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_gallery_carousel-2.jpg'
                                ],
                                '3' => [
                                    'label' => esc_html__( 'Layout 3', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_gallery_carousel-3.jpg'
                                ],
                            ],
                            'prefix_class' => 'pxl-gallery-carousel-layout-',
                        ),
                        
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'adsett'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name'       => 'wp_gallery',
                            'label'      => esc_html__( 'Add Images', 'adsett' ),
                            'type'       => 'gallery',
                            'show_label' => false,
                            'dynamic'    => [
                                'active' => true,
                            ],
                        ),
                        array(
                            'name'    => 'gallery_rand',
                            'label'   => esc_html__( 'Order By', 'adsett' ),
                            'type'    => 'select',
                            'options' => [
                                ''     => esc_html__( 'Default', 'adsett' ),
                                'rand' => esc_html__( 'Random', 'adsett' ),
                            ],
                            'default' => '',
                        ),
                        array(
                            'name'    => 'gallery_click_direct',
                            'label'   => esc_html__( 'Click Direct', 'adsett' ),
                            'type'    => 'select',
                            'options' => [
                                'popup'     => esc_html__( 'Popup', 'adsett' ),
                                'link' => esc_html__( 'Custom Link', 'adsett' ),
                            ],
                            'default' => 'popup',
                            'condition' => ['layout' => '3']
                        ),
                        array(
                            'name' => 'links',
                            'label' => esc_html__('Link items', 'adsett'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'text',
                                    'label' => esc_html__('Text', 'adsett'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'adsett'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                )
                            ),
                            'default' => [
                                [
                                    'text'     => esc_html__('Text 1', 'adsett' ),
                                    'link'     => ['url' => '#','is_external' => 'on'],
                                ] 
                            ],
                            'title_field' => '{{{ text }}}',
                            'condition' => [
                                'layout' => '3',
                                'gallery_click_direct' => 'link'
                            ]
                        ),
                    ),
                ),
                array(
                    'name' => 'section_carousel_settings',
                    'label' => esc_html__('Carousel Settings', 'adsett'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array(
                            array(
                                'name' => 'img_size',
                                'label' => esc_html__('Image Size', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::TEXT,
                                'description' =>  esc_html__('Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).', 'adsett')
                            ), 
                            array(
                                'name'        => 'space_between',
                                'label'       => esc_html__('Space Between', 'adsett'),
                                'description' => esc_html__('Distance between slides in px', 'adsett'),
                                'type'        => \Elementor\Controls_Manager::NUMBER,
                                'default'     => 30
                            ),
                        ), 
                        adsett_carousel_column_settings(),    
                        array( 
                            array(
                                'name' => 'slides_to_scroll',
                                'label' => esc_html__('Slides to scroll', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => '1',
                                'options' => [
                                    '1' => '1',
                                    '2' => '2',
                                    '3' => '3',
                                    '4' => '4',
                                    '5' => '5',
                                    '6' => '6',
                                ],
                            ),
                            array(
                                'name' => 'arrows',
                                'label' => esc_html__('Show Arrows', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'arrows_position',
                                'label' => esc_html__('Arrow Position', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'nav-out-vertical',
                                'options' => [
                                    'df-layout' => esc_html__( 'Default as Layout', 'adsett' ),
                                    'nav-in-vertical' => esc_html__( 'In Vertical', 'adsett' ),
                                    'nav-out-vertical' => esc_html__( 'Out Vertical', 'adsett' ),
                                ],
                                'condition' => [
                                    'arrows' => 'true'
                                ]
                            ),
                            array(
                                'name' => 'arrows_on_hover',
                                'label' => esc_html__('Show Arrows on Hover', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                                'default' => 'false',
                                'condition' => [
                                    'arrows' => 'true'
                                ]
                            ),
                            array(
                                'name' => 'dots',
                                'label' => esc_html__('Show Dots', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'pause_on_hover',
                                'label' => esc_html__('Pause on Hover', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'autoplay',
                                'label' => esc_html__('Autoplay', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'autoplay_speed',
                                'label' => esc_html__('Autoplay Speed', 'adsett'),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => 5000,
                                'condition' => [
                                    'autoplay' => 'true'
                                ]
                            ),
                            array(
                                'name'         => 'gutter',
                                'label'        => esc_html__('Gutter', 'adsett' ),
                                'type'         => 'number'
                            ),
                            array(
                                'name'    => 'center_slide',
                                'label'   => esc_html__('Center Slider', 'adsett'),
                                'type'    => \Elementor\Controls_Manager::SWITCHER,
                                'default' => false
                            ),
                            array(
                                'name' => 'infinite',
                                'label' => esc_html__('Infinite Loop', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name' => 'speed',
                                'label' => esc_html__('Animation Speed', 'adsett'),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => 500,
                            ),
                        ),
                    ),
                ),
            ),
        ),
    ),
    adsett_get_class_widget_path()
);