<?php
// Register Image Galleries Widget
pxl_add_custom_widget(
    array(
        'name'       => 'pxl_galleries',
        'title'      => esc_html__('Pxl Galleries', 'adsett' ),
        'icon'       => 'eicon-gallery-grid',
        'categories' => array('pxltheme-core'),
        'scripts'    => [
            'imagesloaded',
            'isotope',
        ],
        'params'     => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'adsett' ),
                    'tab'      => 'layout',
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Templates', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_galleries-1.jpg'
                                ]
                            ],
                        )
                    )
                ),
                array(
                    'name'     => 'images_section',
                    'label'    => esc_html__('Image Gallery', 'adsett' ),
                    'tab'      => 'content',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'       => 'wp_gallery',
                                'label'      => esc_html__( 'Add Images', 'adsett' ),
                                'type'       => 'gallery',
                                'show_label' => false,
                                'dynamic'    => [
                                    'active' => true,
                                ],
                            ),
                            array(
                                'name'    => 'gallery_rand',
                                'label'   => esc_html__( 'Order By', 'adsett' ),
                                'type'    => 'select',
                                'options' => [
                                    ''     => esc_html__( 'Default', 'adsett' ),
                                    'rand' => esc_html__( 'Random', 'adsett' ),
                                ],
                                'default' => '',
                            ),
                            
                            array(
                                'name' => 'show_load_more',
                                'label' => esc_html__('Show Load More', 'adsett'),
                                'type' => \Elementor\Controls_Manager::SWITCHER,
                            ),
                            array(
                                'name'    => 'load_more_text',
                                'label'   => esc_html__( 'Load More Text', 'adsett' ),
                                'type'    => 'text',
                                'condition' => [
                                    'show_load_more' => 'true',
                                ],
                            ),
                            array(
                                'name'    => 'gallery_show',
                                'label'   => esc_html__( 'Number of item to show', 'adsett' ),
                                'type'    => 'number',
                                'default' => '6',
                                'condition' => [
                                    'show_load_more' => 'true',
                                ],
                            ),
                            array(
                                'name'    => 'gallery_loadmore_show',
                                'label'   => esc_html__( 'Number of item to show on load more', 'adsett' ),
                                'type'    => 'number',
                                'default' => '6',
                                'condition' => [
                                    'show_load_more' => 'true',
                                ],
                            ),
                            array(
                                'name'         => 'load_more_gap_top',
                                'label'        => esc_html__( 'Load More Gap Top', 'adsett' ),
                                'description'  => esc_html__( 'Add extra space at top of load more button','adsett'),
                                'type'         => \Elementor\Controls_Manager::NUMBER,
                                'default'      => 0,
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-gallery-grid .load-more-wrap' => 'margin-top: {{VALUE}}px;',
                                ],
                                'condition' => [
                                    'show_load_more' => 'true',
                                ],
                            ),
                            array(
                                'name' => 'item_padding',
                                'label' => esc_html__('Item Padding', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'default' => [
                                    'top' => '15',
                                    'right' => '15',
                                    'bottom' => '15',
                                    'left' => '15'
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-grid-inner' => 'margin-top: -{{TOP}}{{UNIT}}; margin-right: -{{RIGHT}}{{UNIT}}; margin-bottom: -{{BOTTOM}}{{UNIT}}; margin-left: -{{LEFT}}{{UNIT}};',
                                    '{{WRAPPER}} .pxl-grid-inner .grid-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'control_type' => 'responsive',
                            ),
                            array(
                                'name'         => 'gap_extra',
                                'label'        => esc_html__( 'Item Gap Bottom', 'adsett' ),
                                'description'  => esc_html__( 'Add extra space at bottom of each items','adsett'),
                                'type'         => \Elementor\Controls_Manager::NUMBER,
                                'default'      => 0,
                                'control_type' => 'responsive',
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-grid-inner .grid-item' => 'margin-bottom: {{VALUE}}px;',
                                ],
                            )
                        ),
                        adsett_elementor_animation_opts([
                            'name'   => 'item',
                            'label' => esc_html__('Item', 'adsett'),
                        ])
                    ),
                ),
                array(
                    'name' => 'grid_section',
                    'label' => esc_html__('Grid Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'    => 'layout_mode',
                                'label'   => esc_html__( 'Layout Mode', 'adsett' ),
                                'type'    => \Elementor\Controls_Manager::SELECT,
                                'options' => [
                                    'fitRows' => esc_html__( 'Basic Grid', 'adsett' ),
                                    'masonry' => esc_html__( 'Masonry Grid', 'adsett' ),
                                ],
                                'default'   => 'fitRows'
                            ), 
                        ),
                        adsett_grid_column_settings(),
                        array(
                            array(
                                'name'        => 'img_size',
                                'label'       => esc_html__('Image Size', 'adsett' ),
                                'type'        => \Elementor\Controls_Manager::TEXT,
                                'description' =>  esc_html__('Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).', 'adsett')
                            ),
                        ),
                        array(
                            array(
                                'name'      => 'grid_custom_columns',
                                'label'     => esc_html__('Custom Items Columns', 'adsett'),
                                'type'      => \Elementor\Controls_Manager::REPEATER,
                                'controls' => array_merge(
                                    adsett_grid_custom_column_settings(),
                                    array(
                                        array(
                                            'name'        => 'img_size_c',
                                            'label'       => esc_html__('Image Size', 'adsett' ),
                                            'type'        => \Elementor\Controls_Manager::TEXT,
                                            'description' => esc_html__('Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).', 'adsett'),
                                        ),
                                    ),
                                    adsett_elementor_animation_opts([
                                        'name'  => 'item_c',
                                        'label' => esc_html__('Item', 'adsett'),
                                    ])
                                ),
                            ),
                        )
                        
                    ),
                ),
                 
            )
        )
    ),
    adsett_get_class_widget_path()
);