<?php
// Register Fancy Box Widget
pxl_add_custom_widget(
    array(
        'name'       => 'pxl_fancy_box',
        'title'      => esc_html__( 'PXL Fancy Box', 'adsett' ),
        'icon'       => 'eicon-icon-box',
        'categories' => array('pxltheme-core'),
        'scripts'    => array(
            'pxl-tilt',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'adsett' ),
                    'tab'      => 'layout',
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Templates', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_fancy_box-1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__( 'Layout 2', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_fancy_box-2.jpg'
                                ],
                                '3' => [
                                    'label' => esc_html__( 'Layout 3', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_fancy_box-3.jpg'
                                ],
                                '4' => [
                                    'label' => esc_html__( 'Layout 4', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_fancy_box-4.jpg'
                                ],
                                '5' => [
                                    'label' => esc_html__( 'Layout 5', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_fancy_box-5.jpg'
                                ],
                                '6' => [
                                    'label' => esc_html__( 'Layout 6', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_fancy_box-6.jpg'
                                ],
                            ],
                            'prefix_class' => 'pxl-fancybox-layout-'
                        )
                    )
                ),
                array(
                    'name'     => 'content_section',
                    'label'    => esc_html__( 'Content', 'adsett' ),
                    'tab'      => 'content',
                    'controls' => array(
                        array(
                            'name'             => 'selected_icon',
                            'label'            => esc_html__( 'Icon', 'adsett' ),
                            'type'             => 'icons',
                            'default'          => [
                                'library' => 'flaticon',
                                'value'   => 'flaticon-calling'  
                            ],
                            'condition' => [
                                'layout'    => ['2','3']                            
                            ],
                        ),
                        array(
                            'name'             => 'selected_img',
                            'label'            => esc_html__( 'Image', 'adsett' ),
                            'type'             => 'media',
                            'default'          => '',
                            'condition' => [
                                'layout'    => ['1','5']                            
                            ],
                        ),
                        array(
                            'name'             => 'selected_img_2',
                            'label'            => esc_html__( 'Image 2', 'adsett' ),
                            'type'             => 'media',
                            'default'          => '',
                            'condition' => [
                                'layout'    => ['1']                            
                            ],
                        ),
                        array(
                            'name'             => 'bg_img',
                            'label'            => esc_html__( 'Background Featured Image', 'adsett' ),
                            'type'             => 'media',
                            'default'          => '',
                            'selectors' => [
                                '{{WRAPPER}} .layout-3 .parallax-inner' => 'background-image: url( {{URL}} );',
                            ],
                            'condition' => [
                                'layout'    => ['3']                            
                            ],
                        ),
                        array(
                            'name'     => 'sub_title',
                            'label'    => esc_html__('Sub Title', 'adsett'),
                            'type'     => 'textarea',
                            'default'  => esc_html__('Sub Title', 'adsett'),
                            'condition' => [
                                'layout'    => ['1','2','4','5']                            
                            ],
                        ),
                        array(
                            'name'     => 'title',
                            'label'    => esc_html__('Title', 'adsett'),
                            'type'     => 'textarea',
                            'default'  => esc_html__('Your Title', 'adsett')
                        ),
                        array(
                            'name'     => 'desc',
                            'label'    => esc_html__('Description', 'adsett'),
                            'type'     => 'textarea',
                            'default'  => esc_html__('Mauris dignissim lacus purus, sed rhoncus risus facilisis eu. Phasellus ullamcorper', 'adsett'),
                            'condition' => [
                                'layout'    => ['3','6']                            
                            ],
                        ),
                        array(
                            'name'     => 'extra_text_1',
                            'label'    => esc_html__('Extra Text 1', 'adsett'),
                            'type'     => 'text',
                            'condition' => [
                                'layout'    => ['4']                            
                            ],
                        ),
                        array(
                            'name'     => 'extra_text_2',
                            'label'    => esc_html__('Extra Text 2', 'adsett'),
                            'type'     => 'text',
                            'condition' => [
                                'layout'    => ['4']                            
                            ],
                        ),
                        array(
                            'name'        => 'hyper_link',
                            'label'       => esc_html__( 'Custom Link', 'adsett' ),
                            'type'        => 'url',
                            'placeholder' => esc_html__( 'https://your-link.com', 'adsett' ),
                            'default'     => [
                                'url'         => '#',
                                'is_external' => 'on'
                            ],
                            'condition' => [
                                'layout'    => ['1','3','5','6']                            
                            ] 
                        ),
                        array(
                            'name'     => 'link_text',
                            'label'    => esc_html__('Link Text', 'adsett'),
                            'type'     => 'text',
                            'default'  => esc_html__('Learn more', 'adsett'),
                            'condition' => [
                                'layout'      => ['1','5','6']  
                            ]
                        ),
                        array(
                            'name' => 'is_active',
                            'label' => esc_html__('Is Active?', 'adsett' ),
                            'type'      => 'switcher',
                            'condition' => [
                                'layout'      => ['1']  
                            ]
                        ),
                    )
                ),
                array(
                    'name'     => 'style_section',
                    'label'    => esc_html__( 'Style', 'adsett' ),
                    'tab'      => 'style',
                    'controls' => array_merge(
                        array(
                            array(
                                'name' => 'text_align',
                                'label' => esc_html__( 'Alignment', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::CHOOSE,
                                'control_type' => 'responsive',
                                'options' => [
                                    'start' => [
                                        'title' => esc_html__( 'Start', 'adsett' ),
                                        'icon' => 'eicon-text-align-left',
                                    ],
                                    'center' => [
                                        'title' => esc_html__( 'Center', 'adsett' ),
                                        'icon' => 'eicon-text-align-center',
                                    ],
                                    'end' => [
                                        'title' => esc_html__( 'End', 'adsett' ),
                                        'icon' => 'eicon-text-align-right',
                                    ]
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-fancybox-wrap' => 'justify-content: {{VALUE}};',
                                    '{{WRAPPER}} .pxl-fancybox-wrap' => 'text-align: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name'  => 'icon_size',
                                'label' => esc_html__( 'Icon Size', 'adsett' ),
                                'type'  => 'slider',
                                'range' => [
                                    'px' => [
                                        'min' => 15,
                                        'max' => 300,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-fancy-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                                    '{{WRAPPER}} .pxl-fancy-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                                ],
                                'condition' => [
                                    'layout'    => ['2','3']                            
                                ],
                            ),
                            array(
                                'name' => 'icon_color',
                                'label' => esc_html__('Icon Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-fancy-icon' => 'color: {{VALUE}};',
                                    '{{WRAPPER}} .pxl-fancy-icon svg path' => 'fill: {{VALUE}};',
                                ],
                                'condition' => [
                                    'layout'    => ['2','3']                            
                                ],
                            ),

                            array(
                                'name' => 'icon_bg_color',
                                'label' => esc_html__('Icon Background Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}}.pxl-fancybox-layout-2 .pxl-fancy-icon .pxl-icon, {{WRAPPER}}.pxl-fancybox-layout-3 .pxl-fancy-icon' => 'background-color: {{VALUE}};',
                                ],
                                'condition' => ['layout' => ['2','3']]
                            ),
                            array(
                                'name' => 'background_color',
                                'label' => esc_html__('Background Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-fancybox-wrap .fancy-image .pxl-overlay.bg' => 'background-color: {{VALUE}};',
                                    '{{WRAPPER}} .pxl-fancybox-wrap.layout-6' => 'background-color: {{VALUE}};',
                                ],
                                'condition' => ['layout' => ['5','6']]
                            ),
                            array(
                                'name' => 'background_color_overlay',
                                'label' => esc_html__('Background Color Hover Overlay', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-overlay' => 'background-color: {{VALUE}};',
                                ],
                                'condition' => ['layout' => '3']
                            ),
                            array(
                                'name' => 'sub_title_color',
                                'label' => esc_html__('Sub Title Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .sub-title' => 'color: {{VALUE}};',
                                ],
                                'condition' => [
                                    'layout'    => ['1','2','4','5']                            
                                ],
                            ), 
                            array(
                                'name' => 'title_color',
                                'label' => esc_html__('Title Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .title' => 'color: {{VALUE}};',
                                ],
                            ), 
                            array(
                                'name' => 'title_typography',
                                'label' => esc_html__('Title Typography', 'adsett' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .pxl-fancybox-content .title',
                            ),
                            array(
                                'name' => 'desc_color',
                                'label' => esc_html__('Description Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .desc' => 'color: {{VALUE}};',
                                ],
                                'condition' => ['layout' => ['3','6']]
                            ), 
                            array(
                                'name' => 'extra_text_color',
                                'label' => esc_html__('Extra Text Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .extra-text' => 'color: {{VALUE}};',
                                ],
                                'condition' => ['layout' => ['4']]
                            ), 
                        )
                    )
                ),
                array(
                    'name'     => 'animation_section',
                    'label'    => esc_html__( 'Animation', 'adsett' ),
                    'tab'      => 'style',
                    'controls' => array_merge(
                        adsett_elementor_animation_opts([
                            'name'   => 'img',
                            'label' => esc_html__('Image', 'adsett'),
                            'condition' => ['layout' => '5']
                        ]),
                        adsett_elementor_animation_opts([
                            'name'   => 'title',
                            'label' => esc_html__('Title', 'adsett'),
                        ]),
                        adsett_elementor_animation_opts([
                            'name'   => 'sub_title',
                            'label' => esc_html__('Sub Title', 'adsett'),
                            'condition' => [
                                'layout'    => ['1','2','5']                            
                            ],
                        ]),
                        adsett_elementor_animation_opts([
                            'name'   => 'desc',
                            'label' => esc_html__('Description', 'adsett'),
                            'condition' => ['layout' => ['3','6']]
                        ])
                    )
                ),
                
            )
        )
    ),
    adsett_get_class_widget_path()
);