<?php
// Register Quick Contact Widget
pxl_add_custom_widget(
    array(
		'name'       => 'pxl_contact_info',
		'title'      => esc_html__( 'PXL Contact Info', 'adsett' ),
		'icon'       => 'eicon-mail',
		'categories' => array('pxltheme-core'),
		'scripts'    => [],
		'params'     => array(
            'sections' => array(
                array(
					'name'     => 'layout_section',
					'label'    => esc_html__( 'Layout', 'adsett' ),
					'tab'      => 'layout',
					'controls' => array(
                        array(
							'name'    => 'layout',
							'label'   => esc_html__( 'Templates', 'adsett' ),
							'type'    => 'layoutcontrol',
							'default' => '1',
							'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_contact_info-1.jpg'
                                ],
                            ],
                            'prefix_class' => 'pxl-contact-info-layout-'
                        ),
                    ),
                ),
                  
				array(
					'name'     => 'content_section',
					'label'    => esc_html__( 'Content Settings', 'adsett' ),
					'tab'      => 'content',
					'controls' => array(
                        array(
                            'name'        => 'heading_text',
                            'label'       => esc_html__( 'Heading', 'adsett' ),
                            'type'        => 'text',
                            'placeholder' => esc_html__( 'Enter Heading', 'adsett' ),
                            'default'     => 'Office address',    
                            'label_block' => true
                        ),
                        array(
                            'name'        => 'desc',
                            'label'       => esc_html__( 'Description', 'adsett' ),
                            'type'        => 'textarea',
                            'placeholder' => esc_html__( 'Enter Description', 'adsett' ),
                            'default'     => 'Level 30 130 Lonsdale Street Melbourne VIC 3000 Australia',  
                            'label_block' => true
                        ),
                        array(
                            'name' => 'map_img',
                            'label' => esc_html__('Map Image', 'adsett' ),
                            'type' => 'media',
                        ),
                        array(
                            'name' => 'map_iframe',
                            'label' => esc_html__('Map Iframe', 'adsett' ),
                            'type' => 'textarea',
                        ),
                        array(
                            'name'  => 'image_width',
                            'label' => esc_html__( 'Lightbox Width', 'adsett' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 800,
                                    'step' => 1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 320,
                            ],
                            'selectors' => [
                              '{{WRAPPER}} .pxl-map-wrap' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    ['name' => 'map_img[url]', 'operator' => '!=', 'value' => ''],
                                    ['name' => 'map_iframe', 'operator' => '!=', 'value' => ''],
                                ],
                            ],
                        ),
                        array(
                            'name'  => 'image_height',
                            'label' => esc_html__( 'Lightbox Height', 'adsett' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 800,
                                    'step' => 1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 320,
                            ],
                            'selectors' => [
                              '{{WRAPPER}} .pxl-map-wrap' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    ['name' => 'map_img[url]', 'operator' => '!=', 'value' => ''],
                                    ['name' => 'map_iframe', 'operator' => '!=', 'value' => ''],
                                ],
                            ],
                        ),
                        array(
                            'name'      => 'show_popup',
                            'label'     => esc_html__('Click Show Popup', 'adsett' ),
                            'type'      => \Elementor\Controls_Manager::SWITCHER,
                            'default'   => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    ['name' => 'map_img[url]', 'operator' => '!=', 'value' => ''],
                                    ['name' => 'map_iframe', 'operator' => '!=', 'value' => ''],
                                ],
                            ],
                        ),
                        array(
                            'name' => 'css_filters',
                            'label' => esc_html__('CSS Map Filters', 'adsett' ),
                            'type' => \Elementor\Group_Control_Css_Filter::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-map-wrap',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    ['name' => 'map_img[url]', 'operator' => '!=', 'value' => ''],
                                    ['name' => 'map_iframe', 'operator' => '!=', 'value' => ''],
                                ],
                            ],
                        ),
                    )
				),
				array(
                    'name' => 'qc_style',
                    'label' => esc_html__('Style', 'adsett'),
                    'tab' => 'style',
                    'controls' => array(
                        array(
                            'name'  => 'max_width',
                            'label' => esc_html__( 'Max Width', 'adsett' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 100,
                                    'max' => 800,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-ci-wrap' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name'         => 'ci_align',
                            'label'        => esc_html__( 'Alignment', 'adsett' ),
                            'type'         => 'choose',
                            'control_type' => 'responsive',
                            'options' => [
                                'start' => [
                                    'title' => esc_html__( 'Start', 'adsett' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'adsett' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'end' => [
                                    'title' => esc_html__( 'End', 'adsett' ),
                                    'icon' => 'eicon-text-align-right',
                                ]
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-ci-wrap' => 'text-align: {{VALUE}};',
                            ],
                        ),
                         
                        array(
                            'name' => 'heading_text_color',
                            'label' => esc_html__('Heading Color', 'adsett' ),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .ci-title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'desc_text_color',
                            'label' => esc_html__('Content item Color', 'adsett' ),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .ci-desc' => 'color: {{VALUE}};',
                            ],
                        ), 
                        
                        array(
                            'name' => 'heading_typography',
                            'label' => esc_html__('Heading Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .ci-title',
                        ),
                        array(
                            'name' => 'desc_typography',
                            'label' => esc_html__('Description Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .ci-desc',
                        ),
                        
                    ),
                ),
            )
        )
    ),
    adsett_get_class_widget_path()
);