<?php
// Register Contact Form 7 Widget
if(class_exists('WPCF7')) {
    $cf7 = get_posts('post_type="wpcf7_contact_form"&numberposts=-1');
    $contact_forms = array();
    if ($cf7) {
        foreach ($cf7 as $cform) {
            $contact_forms[$cform->ID] = $cform->post_title;
        }
    } else {
        $contact_forms[esc_html__('No contact forms found', 'adsett')] = 0;
    }

    pxl_add_custom_widget(
        array(
            'name'       => 'pxl_contact_form',
            'title'      => esc_html__('Pxl Contact Form 7', 'adsett'),
            'icon'       => 'eicon-form-horizontal',
            'categories' => array('pxltheme-core'),
            'scripts'    => array(),
            'params'     => array(
                'sections' => array(
                    array(
                        'name'     => 'source_section',
                        'label'    => esc_html__('Source Settings', 'adsett'),
                        'tab'      => 'content',
                        'controls' => array(
                            array(
                                'name' => 'form_id',
                                'label' => esc_html__('Select Form', 'adsett'),
                                'type' => 'select',
                                'options' => $contact_forms,
                            ),
                            array(
                                'name'  => 'width',
                                'label' => esc_html__( 'Width', 'adsett' ),
                                'type'  => 'slider',
                                'control_type' => 'responsive',
                                'size_units' => [ 'px','%' ],
                                'range' => [
                                    'px' => [
                                        'min' => 100,
                                        'max' => 1920,
                                    ],
                                    '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-cf7-wrap' => 'width: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name'        => 'bg_color',
                                'label'       => esc_html__( 'Background Color', 'adsett' ),
                                'type'        => 'color',
                                'selectors'  => [
                                    '{{WRAPPER}} .pxl-cf7-wrap' => 'background-color:{{VALUE}};'
                                ]
                            )
                        )
                    ) 
                )
            )
        ),
        adsett_get_class_widget_path()
    );
}