<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_cliptext',
        'title' => esc_html__('PXL Clip Text', 'adsett' ),
        'icon' => 'eicon-post-content',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'adsett' ),
                    'tab'      => 'layout',
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Templates', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_cliptext-1.jpg'
                                ],
                                 
                            ],
                            'prefix_class' => 'pxl-cliptext-layout-'
                        ),
                    )
                ),
                array(
                    'name'     => 'content_section',
                    'label'    => esc_html__( 'Content', 'adsett' ),
                    'tab'      => 'content',
                    'controls' => array(
                        array(
                            'name'        => 'bg_image',
                            'label'       => esc_html__('Background Image', 'adsett'),
                            'type'        => 'media',
                            'selectors' => [
                                '{{WRAPPER}} .bg-img' => 'background-image: url( {{URL}} );',
                            ],
                        ),
                        array(
                            'name'     => 'textclip',
                            'label'    => esc_html__('Clip Text', 'adsett'),
                            'type'     => 'text',
                            'label_block' => true,
                            'default'  => '24'
                        ),
                        array(
                            'name'     => 'title',
                            'label'    => esc_html__('Title', 'adsett'),
                            'type'     => 'textarea',
                            'default'  => 'Year Experience'
                        ),
                        array(
                            'name'        => 'text_bg',
                            'label'       => esc_html__('Clip Text Background', 'adsett'),
                            'type'        => 'media',
                            'selectors' => [
                                '{{WRAPPER}} .text-clip' => 'background-image: url( {{URL}} );',
                            ],
                        ),
                        array(
                            'name'        => 'text_color',
                            'label'       => esc_html__('Clip Text Color', 'adsett'),
                            'type'        => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .text-clip' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name'        => 'title_color',
                            'label'       => esc_html__('Title Color', 'adsett'),
                            'type'        => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'cliptext_typography',
                            'label' => esc_html__('Text Clip Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .text-clip',
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Title Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .title',
                        ),
                    )
                ),  
                array(
                    'name' => 'parallax_section',
                    'label' => esc_html__('Parallax Settings', 'adsett' ),
                    'tab'      => 'content',
                    'controls' => [
                        [
                            'name' => 'pxl_parallax',
                            'label' => esc_html__( 'Parallax Type', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                ''        => esc_html__( 'None', 'adsett' ),
                                'x'       => esc_html__( 'Transform X', 'adsett' ),
                                'y'       => esc_html__( 'Transform Y', 'adsett' ),
                                'z'       => esc_html__( 'Transform Z', 'adsett' ),
                                'rotateX' => esc_html__( 'RotateX', 'adsett' ),
                                'rotateY' => esc_html__( 'RotateY', 'adsett' ),
                                'rotateZ' => esc_html__( 'RotateZ', 'adsett' ),
                                'scaleX'  => esc_html__( 'ScaleX', 'adsett' ),
                                'scaleY'  => esc_html__( 'ScaleY', 'adsett' ),
                                'scaleZ'  => esc_html__( 'ScaleZ', 'adsett' ),
                                'scale'   => esc_html__( 'Scale', 'adsett' ),
                            ],
                        ],
                        [
                            'name' => 'parallax_value',
                            'label' => esc_html__('Value', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '',
                            'condition' => [ 'pxl_parallax!' => '']  
                        ],
                    ]
                ),
            ),
        ),
    ),
    adsett_get_class_widget_path()
);