<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_carrer',
        'title' => esc_html__('PXL Carrer', 'adsett' ),
        'icon' => 'eicon-post-content',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'adsett' ),
                    'tab'      => 'layout',
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Templates', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_carrer-1.jpg'
                                ],
                                 
                            ],
                            'prefix_class' => 'pxl-carrer-layout-'
                        ),
                    )
                ),
                array(
                    'name'     => 'content_section',
                    'label'    => esc_html__( 'Content', 'adsett' ),
                    'tab'      => 'content',
                    'controls' => array(
                        array(
                            'name'     => 'number',
                            'label'    => esc_html__('Number Index', 'adsett'),
                            'type'     => 'text',
                            'label_block' => true,
                            'default'  => '/1'
                        ),
                        array(
                            'name'     => 'title',
                            'label'    => esc_html__('Title', 'adsett'),
                            'type'     => 'textarea',
                            'label_block' => true,
                            'default'  => 'Distribution Manager'
                        ),
                        array(
                            'name'     => 'date',
                            'label'    => esc_html__('Date', 'adsett'),
                            'type'     => 'text',
                            'label_block' => true,
                            'default'  => 'August 2, 2022'
                        ),
                        array(
                            'name'     => 'location',
                            'label'    => esc_html__('Location', 'adsett'),
                            'type'     => 'text',
                            'label_block' => true,
                            'default'  => 'Vacaville, CA, US'
                        ),
                        array(
                            'name'     => 'desc',
                            'label'    => esc_html__('Description', 'adsett'),
                            'type'     => 'textarea',
                            'label_block' => true,
                            'default'  => 'The distribution manager is responsible for managing safe, efficient, and timely flow of finished goods from warehousing.'
                        ),
                        array(
                            'name'     => 'time',
                            'label'    => esc_html__('Time', 'adsett'),
                            'type'     => 'text',
                            'label_block' => true,
                            'default'  => 'Full Time'
                        ), 
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'placeholder' => esc_html__('https://your-link.com', 'adsett' ),
                            'default' => [
                                'url' => '#',
                            ]
                        ),
                    )
                ),  
            ),
        ),
    ),
    adsett_get_class_widget_path()
);