<?php
// Register Button Widget
pxl_add_custom_widget(
    array(
        'name'       => 'pxl_button',
        'title'      => esc_html__( 'PXL Button', 'adsett' ),
        'icon'       => 'eicon-button',
        'categories' => array('pxltheme-core'),
        'params'     => array(
            'sections' => array(
                array(
                    'name' => 'source_section',
                    'label' => esc_html__('Source Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array_merge(
                        adsett_button_settings([
                            'btn_text' => esc_html__('Click Here', 'adsett' )
                        ])
                    )
                ),
                array(
                    'name' => 'icon_section',
                    'label' => esc_html__('Icon Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        
                        array(
                            'name' => 'btn_icon',
                            'label' => esc_html__('Icon', 'adsett' ),
                            'type' => 'icons',
                            'label_block' => true,
                            'fa4compatibility' => 'icon',
                        ),
                        array(
                            'name' => 'icon_align',
                            'label' => esc_html__('Icon Position', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'right',
                            'options' => [
                                'right' => esc_html__('After', 'adsett' ),
                                'left' => esc_html__('Before', 'adsett' ),
                            ],
                        ),
                        array(
                            'name' => 'icon_space_left',
                            'label' => esc_html__('Icon Space Left', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper .pxl-button-icon.pxl-align-icon-left' => 'margin-right: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'icon_align' => ['left'],
                            ],
                        ),
                        array(
                            'name' => 'icon_space_right',
                            'label' => esc_html__('Icon Space Right', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper .pxl-button-icon.pxl-align-icon-right' => 'margin-left: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'icon_align' => ['right'],
                            ],
                        ),
                        array(
                            'name' => 'icon_font_size',
                            'label' => esc_html__('Icon Font Size', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper .pxl-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                            ],
                        ), 
                    ),
                ),
                array(
                    'name' => 'style_section',
                    'label' => esc_html__('Style Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array( 
                        array(
                            'name' => 'text_align',
                            'label' => esc_html__('Alignment', 'adsett' ),
                            'type' => 'choose',
                            'control_type' => 'responsive',
                            'options' => [
                                'start' => [
                                    'title' => esc_html__( 'Start', 'adsett' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'adsett' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'end' => [
                                    'title' => esc_html__( 'End', 'adsett' ),
                                    'icon' => 'eicon-text-align-right',
                                ]
                            ],
                            'prefix_class' => 'elementor-align-',
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper' => 'justify-content: {{VALUE}};'
                            ],
                        ),
                        array(
                            'name' => 'btn_padding',
                            'label' => esc_html__('Padding', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper .pxl-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'btn_min_width',
                            'label' => esc_html__('Min Width (px)', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 50,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-btn' => 'min-width: {{SIZE}}{{UNIT}};',
                            ]
                        ),
                        array(
                            'name' => 'btn_full',
                            'label' => esc_html__('Full Width', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'options' => [
                                'auto' => [
                                    'title' => esc_html__( 'Auto', 'adsett' ),
                                    'icon' => 'eicon-justify-center-h',
                                ],
                                '100%' => [
                                    'title' => esc_html__( 'Full', 'adsett' ),
                                    'icon' => 'eicon-justify-space-between-h',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper .pxl-btn' => 'width: {{VALUE}};',
                            ], 
                        ),
                        array(
                            'name' => 'in_dark',
                            'label' => esc_html__('Is In Dark?', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '',
                            'options' => [
                                '' => esc_html__('Default', 'adsett' ),
                                'in-dark' => esc_html__('In Dark', 'adsett' ),
                            ],
                        ),
                        array(
                            'name' => 'typography',
                            'label' => esc_html__('Typography', 'adsett' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-button-wrapper .pxl-btn',
                        ),
                        
                        array(
                            'name' => 'btn_color',
                            'label' => esc_html__('Text Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper .pxl-btn' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'btn_color_hover',
                            'label' => esc_html__('Text Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper .pxl-btn:hover' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'btn_bg_color',
                            'label' => esc_html__('Background Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper .pxl-btn' => 'background: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'btn_bg_color_hover',
                            'label' => esc_html__('Background Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper .pxl-btn:hover, {{WRAPPER}} .pxl-button-wrapper .pxl-btn:focus, {{WRAPPER}} .pxl-button-wrapper .pxl-btn:active' => 'background: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'line_border_color',
                            'label' => esc_html__('Border Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-btn:after' => 'border-color: {{VALUE}} !important;',
                            ],
                            'condition' => [ 'style!' => 'default']
                        ),
                        array(
                            'name' => 'line_border_color_hover',
                            'label' => esc_html__('Border Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-btn .draw-top-right:before, {{WRAPPER}} .pxl-btn .draw-top-right:after, {{WRAPPER}} .pxl-btn .draw-bottom-left:before, {{WRAPPER}} .pxl-btn .draw-bottom-left:after' => 'background-color: {{VALUE}} !important;',
                            ],
                            'condition' => [ 'style!' => 'default']
                        ),
                        array(
                            'name' => 'border_type',
                            'label' => esc_html__( 'Border Type', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => esc_html__( 'None', 'adsett' ),
                                'solid' => esc_html__( 'Solid', 'adsett' ),
                                'double' => esc_html__( 'Double', 'adsett' ),
                                'dotted' => esc_html__( 'Dotted', 'adsett' ),
                                'dashed' => esc_html__( 'Dashed', 'adsett' ),
                                'groove' => esc_html__( 'Groove', 'adsett' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper .pxl-btn' => 'border-style: {{VALUE}} !important;',
                            ],
                            'condition' => [ 'style' => 'default']
                        ),
                        
                        array(
                            'name' => 'border_width',
                            'label' => esc_html__( 'Border Width', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper .pxl-btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                            ],
                            'responsive' => true,
                            'condition' => [ 'style' => 'default']
                        ),
                        array(
                            'name' => 'border_color',
                            'label' => esc_html__( 'Border Color', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper .pxl-btn' => 'border-color: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'style' => 'default',
                                'border_type!' => ''
                            ],
                        ),
                        array(
                            'name' => 'border_color_hover',
                            'label' => esc_html__( 'Border Color Hover', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper .pxl-btn:hover' => 'border-color: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'style' => 'default',
                                'border_type!' => ''
                            ],
                        ),
                        array(
                            'name' => 'btn_border_radius',
                            'label' => esc_html__('Border Radius', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper .pxl-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'condition' => [ 'style' => 'default']
                        ),
                        array(
                            'name'        => 'btn_square_width',
                            'label' => esc_html__( 'Square Width', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => -1000,
                                    'max' => 1000,
                                ],
                            ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button-wrapper .pxl-btn' => 'width: {{SIZE}}{{UNIT}};min-width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [ 'style' => 'default']
                        ), 
                    ),
                ),
                array(
                    'name' => 'parallax_section',
                    'label' => esc_html__('Parallax Settings', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'pxl_parallax',
                            'label' => esc_html__( 'Parallax Type', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                ''        => esc_html__( 'None', 'adsett' ),
                                'x'       => esc_html__( 'Transform X', 'adsett' ),
                                'y'       => esc_html__( 'Transform Y', 'adsett' ),
                                'z'       => esc_html__( 'Transform Z', 'adsett' ),
                                'rotateX' => esc_html__( 'RotateX', 'adsett' ),
                                'rotateY' => esc_html__( 'RotateY', 'adsett' ),
                                'rotateZ' => esc_html__( 'RotateZ', 'adsett' ),
                                'scaleX'  => esc_html__( 'ScaleX', 'adsett' ),
                                'scaleY'  => esc_html__( 'ScaleY', 'adsett' ),
                                'scaleZ'  => esc_html__( 'ScaleZ', 'adsett' ),
                                'scale'   => esc_html__( 'Scale', 'adsett' ),
                            ],
                        ),
                        array(
                            'name' => 'parallax_value',
                            'label' => esc_html__('Value', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '',
                            'condition' => [ 'pxl_parallax!' => '']  
                        ),
                    )
                )
            ),
        )
    ),
    adsett_get_class_widget_path()
);