<?php
pxl_add_custom_widget(
    array(
        'name'       => 'pxl_block_quote',
        'title'      => esc_html__( 'PXL Block Quote', 'adsett' ),
        'icon'       => 'eicon-blockquote',
        'categories' => array('pxltheme-core'),
        'scripts'    => array(),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'adsett' ),
                    'tab'      => 'layout',
                    'controls' => array(
                         
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Templates', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/block_quote-1.jpg'
                                ]
                            ],
                            'prefix_class' => 'pxl-blockquote-layout-'
                        )
                    )
                ),
                array(
                    'name'     => 'text_section',
                    'label'    => esc_html__( 'Content & Client Name', 'adsett' ),
                    'tab'      => 'content',
                    'controls' => array(
                        array(
                            'name' => 'text_align',
                            'label' => esc_html__( 'Alignment', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'start' => [
                                    'title' => esc_html__( 'Start', 'adsett' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'adsett' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'end' => [
                                    'title' => esc_html__( 'End', 'adsett' ),
                                    'icon' => 'eicon-text-align-right',
                                ]
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-block-quote-wrap' => 'justify-content: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name'     => 'bq_content',
                            'label'    => esc_html__('Content', 'adsett'),
                            'type'     => 'textarea',
                            'default'  => esc_html__('“ Not quite a cafe, not quite a restaurant offer innovative fare for breakfast, dinner, alongside specialty coffee ”', 'adsett')
                        ),
                        array(
                            'name'     => 'bq_client_name',
                            'label'    => esc_html__('Client Name', 'adsett'),
                            'type'     => 'text',
                            'label_block' => true,
                            'default'  => 'Martin & Michiel - Guests from Norway'
                        ) 
                    )
                ), 
            )
        )
    ),
    adsett_get_class_widget_path()
);