<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_banner',
        'title' => esc_html__('PXL Banner', 'adsett' ),
        'icon' => 'eicon-image-rollover',
        'categories' => array('pxltheme-core'),
        'scripts'    => array(
            'pxl-tilt',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'adsett' ),
                    'tab'      => 'layout',
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Templates', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_banner-1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__( 'Layout 2', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_banner-2.jpg'
                                ],
                                 
                            ],
                            'prefix_class' => 'pxl-banner-layout-'
                        ),
                    ),
                ),
                array(
                    'name' => 'content_section',
                    'label' => esc_html__('Content', 'adsett' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name'             => 'selected_img',
                            'label'            => esc_html__( 'Image', 'adsett' ),
                            'type'             => 'media',
                            'default'          => '',
                            'condition' => ['layout'    => '2'],
                        ),
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' =>  esc_html__('Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).', 'adsett'),
                            'condition' => ['layout'    => '2'],
                        ),
                        array(
                            'name'     => 'sub_title',
                            'label'    => esc_html__('Sub Title', 'adsett'),
                            'type'     => 'textarea',
                            'default'  => esc_html__('Sub Title', 'adsett'),
                            'condition' => ['layout' => '1']
                        ), 
                        array(
                            'name'     => 'title',
                            'label'    => esc_html__('Title', 'adsett'),
                            'type'     => 'text',
                            'default'  => esc_html__('Your Title', 'adsett'),
                            'label_block' => true,
                        ),
                        array(
                            'name'     => 'desc',
                            'label'    => esc_html__('Description', 'adsett'),
                            'type'     => 'textarea',
                            'default'  => esc_html__('Your description', 'adsett'),
                            'condition' => ['layout' => '1']
                        ),
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'adsett'),
                            'type' => \Elementor\Controls_Manager::URL,
                        ) 
                    ),
                ),
                array(
                    'name' => 'section_style_bn',
                    'label' => esc_html__('Style', 'adsett'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array_merge(
                        array(
                            array(
                                'name' => 'background',
                                'label' => esc_html__('Background Image', 'adsett' ),
                                'type'   => \Elementor\Group_Control_Background::get_type(),
                                'types' => ['classic'],
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .pxl-banner',
                            ),
                            array(
                                'name'  => 'bn_width',
                                'label' => esc_html__( 'Width (px)', 'adsett' ),
                                'type'  => 'slider',
                                'control_type' => 'responsive',
                                'range' => [
                                    'px' => [
                                        'min' => 100,
                                        'max' => 1000,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-banner' => 'width: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name'  => 'bn_height',
                                'label' => esc_html__( 'Height (px)', 'adsett' ),
                                'type'  => 'slider',
                                'control_type' => 'responsive',
                                'range' => [
                                    'px' => [
                                        'min' => 100,
                                        'max' => 1000,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-banner' => 'height: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'content_color',
                                'label' => esc_html__('Content Color', 'adsett' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-banner' => 'color: {{VALUE}};',
                                ],
                            ), 
                            
                        ) 
                    ),
                ),
            ),
        ),
    ),
    adsett_get_class_widget_path()
);